/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.personalize.model.PersonalizeRequest;
import software.amazon.awssdk.services.personalize.model.RecommenderConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRecommenderRequest
extends PersonalizeRequest
implements ToCopyableBuilder<Builder, UpdateRecommenderRequest> {
    private static final SdkField<String> RECOMMENDER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommenderArn").getter(UpdateRecommenderRequest.getter(UpdateRecommenderRequest::recommenderArn)).setter(UpdateRecommenderRequest.setter(Builder::recommenderArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommenderArn").build()}).build();
    private static final SdkField<RecommenderConfig> RECOMMENDER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("recommenderConfig").getter(UpdateRecommenderRequest.getter(UpdateRecommenderRequest::recommenderConfig)).setter(UpdateRecommenderRequest.setter(Builder::recommenderConfig)).constructor(RecommenderConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommenderConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDER_ARN_FIELD, RECOMMENDER_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateRecommenderRequest.memberNameToFieldInitializer();
    private final String recommenderArn;
    private final RecommenderConfig recommenderConfig;

    private UpdateRecommenderRequest(BuilderImpl builder) {
        super(builder);
        this.recommenderArn = builder.recommenderArn;
        this.recommenderConfig = builder.recommenderConfig;
    }

    public final String recommenderArn() {
        return this.recommenderArn;
    }

    public final RecommenderConfig recommenderConfig() {
        return this.recommenderConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.recommenderArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommenderConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRecommenderRequest)) {
            return false;
        }
        UpdateRecommenderRequest other = (UpdateRecommenderRequest)((Object)obj);
        return Objects.equals(this.recommenderArn(), other.recommenderArn()) && Objects.equals(this.recommenderConfig(), other.recommenderConfig());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateRecommenderRequest").add("RecommenderArn", (Object)this.recommenderArn()).add("RecommenderConfig", (Object)this.recommenderConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "recommenderArn": {
                return Optional.ofNullable(clazz.cast(this.recommenderArn()));
            }
            case "recommenderConfig": {
                return Optional.ofNullable(clazz.cast(this.recommenderConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("recommenderArn", RECOMMENDER_ARN_FIELD);
        map.put("recommenderConfig", RECOMMENDER_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateRecommenderRequest, T> g) {
        return obj -> g.apply((UpdateRecommenderRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PersonalizeRequest.BuilderImpl
    implements Builder {
        private String recommenderArn;
        private RecommenderConfig recommenderConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRecommenderRequest model) {
            super(model);
            this.recommenderArn(model.recommenderArn);
            this.recommenderConfig(model.recommenderConfig);
        }

        public final String getRecommenderArn() {
            return this.recommenderArn;
        }

        public final void setRecommenderArn(String recommenderArn) {
            this.recommenderArn = recommenderArn;
        }

        @Override
        public final Builder recommenderArn(String recommenderArn) {
            this.recommenderArn = recommenderArn;
            return this;
        }

        public final RecommenderConfig.Builder getRecommenderConfig() {
            return this.recommenderConfig != null ? this.recommenderConfig.toBuilder() : null;
        }

        public final void setRecommenderConfig(RecommenderConfig.BuilderImpl recommenderConfig) {
            this.recommenderConfig = recommenderConfig != null ? recommenderConfig.build() : null;
        }

        @Override
        public final Builder recommenderConfig(RecommenderConfig recommenderConfig) {
            this.recommenderConfig = recommenderConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRecommenderRequest build() {
            return new UpdateRecommenderRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PersonalizeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRecommenderRequest> {
        public Builder recommenderArn(String var1);

        public Builder recommenderConfig(RecommenderConfig var1);

        default public Builder recommenderConfig(Consumer<RecommenderConfig.Builder> recommenderConfig) {
            return this.recommenderConfig((RecommenderConfig)((RecommenderConfig.Builder)RecommenderConfig.builder().applyMutation(recommenderConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

