/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.personalize.model.HyperParametersCopier;
import software.amazon.awssdk.services.personalize.model.TrainingDataConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecommenderConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecommenderConfig> {
    private static final SdkField<Map<String, String>> ITEM_EXPLORATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("itemExplorationConfig").getter(RecommenderConfig.getter(RecommenderConfig::itemExplorationConfig)).setter(RecommenderConfig.setter(Builder::itemExplorationConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemExplorationConfig").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> MIN_RECOMMENDATION_REQUESTS_PER_SECOND_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("minRecommendationRequestsPerSecond").getter(RecommenderConfig.getter(RecommenderConfig::minRecommendationRequestsPerSecond)).setter(RecommenderConfig.setter(Builder::minRecommendationRequestsPerSecond)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minRecommendationRequestsPerSecond").build()}).build();
    private static final SdkField<TrainingDataConfig> TRAINING_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("trainingDataConfig").getter(RecommenderConfig.getter(RecommenderConfig::trainingDataConfig)).setter(RecommenderConfig.setter(Builder::trainingDataConfig)).constructor(TrainingDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingDataConfig").build()}).build();
    private static final SdkField<Boolean> ENABLE_METADATA_WITH_RECOMMENDATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableMetadataWithRecommendations").getter(RecommenderConfig.getter(RecommenderConfig::enableMetadataWithRecommendations)).setter(RecommenderConfig.setter(Builder::enableMetadataWithRecommendations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableMetadataWithRecommendations").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_EXPLORATION_CONFIG_FIELD, MIN_RECOMMENDATION_REQUESTS_PER_SECOND_FIELD, TRAINING_DATA_CONFIG_FIELD, ENABLE_METADATA_WITH_RECOMMENDATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RecommenderConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, String> itemExplorationConfig;
    private final Integer minRecommendationRequestsPerSecond;
    private final TrainingDataConfig trainingDataConfig;
    private final Boolean enableMetadataWithRecommendations;

    private RecommenderConfig(BuilderImpl builder) {
        this.itemExplorationConfig = builder.itemExplorationConfig;
        this.minRecommendationRequestsPerSecond = builder.minRecommendationRequestsPerSecond;
        this.trainingDataConfig = builder.trainingDataConfig;
        this.enableMetadataWithRecommendations = builder.enableMetadataWithRecommendations;
    }

    public final boolean hasItemExplorationConfig() {
        return this.itemExplorationConfig != null && !(this.itemExplorationConfig instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> itemExplorationConfig() {
        return this.itemExplorationConfig;
    }

    public final Integer minRecommendationRequestsPerSecond() {
        return this.minRecommendationRequestsPerSecond;
    }

    public final TrainingDataConfig trainingDataConfig() {
        return this.trainingDataConfig;
    }

    public final Boolean enableMetadataWithRecommendations() {
        return this.enableMetadataWithRecommendations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItemExplorationConfig() ? this.itemExplorationConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.minRecommendationRequestsPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableMetadataWithRecommendations());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommenderConfig)) {
            return false;
        }
        RecommenderConfig other = (RecommenderConfig)obj;
        return this.hasItemExplorationConfig() == other.hasItemExplorationConfig() && Objects.equals(this.itemExplorationConfig(), other.itemExplorationConfig()) && Objects.equals(this.minRecommendationRequestsPerSecond(), other.minRecommendationRequestsPerSecond()) && Objects.equals(this.trainingDataConfig(), other.trainingDataConfig()) && Objects.equals(this.enableMetadataWithRecommendations(), other.enableMetadataWithRecommendations());
    }

    public final String toString() {
        return ToString.builder((String)"RecommenderConfig").add("ItemExplorationConfig", this.hasItemExplorationConfig() ? this.itemExplorationConfig() : null).add("MinRecommendationRequestsPerSecond", (Object)this.minRecommendationRequestsPerSecond()).add("TrainingDataConfig", (Object)this.trainingDataConfig()).add("EnableMetadataWithRecommendations", (Object)this.enableMetadataWithRecommendations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "itemExplorationConfig": {
                return Optional.ofNullable(clazz.cast(this.itemExplorationConfig()));
            }
            case "minRecommendationRequestsPerSecond": {
                return Optional.ofNullable(clazz.cast(this.minRecommendationRequestsPerSecond()));
            }
            case "trainingDataConfig": {
                return Optional.ofNullable(clazz.cast(this.trainingDataConfig()));
            }
            case "enableMetadataWithRecommendations": {
                return Optional.ofNullable(clazz.cast(this.enableMetadataWithRecommendations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("itemExplorationConfig", ITEM_EXPLORATION_CONFIG_FIELD);
        map.put("minRecommendationRequestsPerSecond", MIN_RECOMMENDATION_REQUESTS_PER_SECOND_FIELD);
        map.put("trainingDataConfig", TRAINING_DATA_CONFIG_FIELD);
        map.put("enableMetadataWithRecommendations", ENABLE_METADATA_WITH_RECOMMENDATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecommenderConfig, T> g) {
        return obj -> g.apply((RecommenderConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> itemExplorationConfig = DefaultSdkAutoConstructMap.getInstance();
        private Integer minRecommendationRequestsPerSecond;
        private TrainingDataConfig trainingDataConfig;
        private Boolean enableMetadataWithRecommendations;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommenderConfig model) {
            this.itemExplorationConfig(model.itemExplorationConfig);
            this.minRecommendationRequestsPerSecond(model.minRecommendationRequestsPerSecond);
            this.trainingDataConfig(model.trainingDataConfig);
            this.enableMetadataWithRecommendations(model.enableMetadataWithRecommendations);
        }

        public final Map<String, String> getItemExplorationConfig() {
            if (this.itemExplorationConfig instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.itemExplorationConfig;
        }

        public final void setItemExplorationConfig(Map<String, String> itemExplorationConfig) {
            this.itemExplorationConfig = HyperParametersCopier.copy(itemExplorationConfig);
        }

        @Override
        public final Builder itemExplorationConfig(Map<String, String> itemExplorationConfig) {
            this.itemExplorationConfig = HyperParametersCopier.copy(itemExplorationConfig);
            return this;
        }

        public final Integer getMinRecommendationRequestsPerSecond() {
            return this.minRecommendationRequestsPerSecond;
        }

        public final void setMinRecommendationRequestsPerSecond(Integer minRecommendationRequestsPerSecond) {
            this.minRecommendationRequestsPerSecond = minRecommendationRequestsPerSecond;
        }

        @Override
        public final Builder minRecommendationRequestsPerSecond(Integer minRecommendationRequestsPerSecond) {
            this.minRecommendationRequestsPerSecond = minRecommendationRequestsPerSecond;
            return this;
        }

        public final TrainingDataConfig.Builder getTrainingDataConfig() {
            return this.trainingDataConfig != null ? this.trainingDataConfig.toBuilder() : null;
        }

        public final void setTrainingDataConfig(TrainingDataConfig.BuilderImpl trainingDataConfig) {
            this.trainingDataConfig = trainingDataConfig != null ? trainingDataConfig.build() : null;
        }

        @Override
        public final Builder trainingDataConfig(TrainingDataConfig trainingDataConfig) {
            this.trainingDataConfig = trainingDataConfig;
            return this;
        }

        public final Boolean getEnableMetadataWithRecommendations() {
            return this.enableMetadataWithRecommendations;
        }

        public final void setEnableMetadataWithRecommendations(Boolean enableMetadataWithRecommendations) {
            this.enableMetadataWithRecommendations = enableMetadataWithRecommendations;
        }

        @Override
        public final Builder enableMetadataWithRecommendations(Boolean enableMetadataWithRecommendations) {
            this.enableMetadataWithRecommendations = enableMetadataWithRecommendations;
            return this;
        }

        public RecommenderConfig build() {
            return new RecommenderConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecommenderConfig> {
        public Builder itemExplorationConfig(Map<String, String> var1);

        public Builder minRecommendationRequestsPerSecond(Integer var1);

        public Builder trainingDataConfig(TrainingDataConfig var1);

        default public Builder trainingDataConfig(Consumer<TrainingDataConfig.Builder> trainingDataConfig) {
            return this.trainingDataConfig((TrainingDataConfig)((TrainingDataConfig.Builder)TrainingDataConfig.builder().applyMutation(trainingDataConfig)).build());
        }

        public Builder enableMetadataWithRecommendations(Boolean var1);
    }
}

