/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.personalize.model.MetricAttributionSummary;
import software.amazon.awssdk.services.personalize.model.MetricAttributionsCopier;
import software.amazon.awssdk.services.personalize.model.PersonalizeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMetricAttributionsResponse
extends PersonalizeResponse
implements ToCopyableBuilder<Builder, ListMetricAttributionsResponse> {
    private static final SdkField<List<MetricAttributionSummary>> METRIC_ATTRIBUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metricAttributions").getter(ListMetricAttributionsResponse.getter(ListMetricAttributionsResponse::metricAttributions)).setter(ListMetricAttributionsResponse.setter(Builder::metricAttributions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricAttributions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricAttributionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListMetricAttributionsResponse.getter(ListMetricAttributionsResponse::nextToken)).setter(ListMetricAttributionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_ATTRIBUTIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("metricAttributions", METRIC_ATTRIBUTIONS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<MetricAttributionSummary> metricAttributions;
    private final String nextToken;

    private ListMetricAttributionsResponse(BuilderImpl builder) {
        super(builder);
        this.metricAttributions = builder.metricAttributions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasMetricAttributions() {
        return this.metricAttributions != null && !(this.metricAttributions instanceof SdkAutoConstructList);
    }

    public final List<MetricAttributionSummary> metricAttributions() {
        return this.metricAttributions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricAttributions() ? this.metricAttributions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMetricAttributionsResponse)) {
            return false;
        }
        ListMetricAttributionsResponse other = (ListMetricAttributionsResponse)((Object)obj);
        return this.hasMetricAttributions() == other.hasMetricAttributions() && Objects.equals(this.metricAttributions(), other.metricAttributions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListMetricAttributionsResponse").add("MetricAttributions", this.hasMetricAttributions() ? this.metricAttributions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "metricAttributions": {
                return Optional.ofNullable(clazz.cast(this.metricAttributions()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListMetricAttributionsResponse, T> g) {
        return obj -> g.apply((ListMetricAttributionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PersonalizeResponse.BuilderImpl
    implements Builder {
        private List<MetricAttributionSummary> metricAttributions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMetricAttributionsResponse model) {
            super(model);
            this.metricAttributions(model.metricAttributions);
            this.nextToken(model.nextToken);
        }

        public final List<MetricAttributionSummary.Builder> getMetricAttributions() {
            List<MetricAttributionSummary.Builder> result = MetricAttributionsCopier.copyToBuilder(this.metricAttributions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricAttributions(Collection<MetricAttributionSummary.BuilderImpl> metricAttributions) {
            this.metricAttributions = MetricAttributionsCopier.copyFromBuilder(metricAttributions);
        }

        @Override
        public final Builder metricAttributions(Collection<MetricAttributionSummary> metricAttributions) {
            this.metricAttributions = MetricAttributionsCopier.copy(metricAttributions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricAttributions(MetricAttributionSummary ... metricAttributions) {
            this.metricAttributions(Arrays.asList(metricAttributions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricAttributions(Consumer<MetricAttributionSummary.Builder> ... metricAttributions) {
            this.metricAttributions(Stream.of(metricAttributions).map(c -> (MetricAttributionSummary)((MetricAttributionSummary.Builder)MetricAttributionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMetricAttributionsResponse build() {
            return new ListMetricAttributionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PersonalizeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMetricAttributionsResponse> {
        public Builder metricAttributions(Collection<MetricAttributionSummary> var1);

        public Builder metricAttributions(MetricAttributionSummary ... var1);

        public Builder metricAttributions(Consumer<MetricAttributionSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

