/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.personalize.model.S3DataConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricAttributionOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricAttributionOutput> {
    private static final SdkField<S3DataConfig> S3_DATA_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3DataDestination").getter(MetricAttributionOutput.getter(MetricAttributionOutput::s3DataDestination)).setter(MetricAttributionOutput.setter(Builder::s3DataDestination)).constructor(S3DataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3DataDestination").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(MetricAttributionOutput.getter(MetricAttributionOutput::roleArn)).setter(MetricAttributionOutput.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_DATA_DESTINATION_FIELD, ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("s3DataDestination", S3_DATA_DESTINATION_FIELD);
            this.put("roleArn", ROLE_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final S3DataConfig s3DataDestination;
    private final String roleArn;

    private MetricAttributionOutput(BuilderImpl builder) {
        this.s3DataDestination = builder.s3DataDestination;
        this.roleArn = builder.roleArn;
    }

    public final S3DataConfig s3DataDestination() {
        return this.s3DataDestination;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3DataDestination());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricAttributionOutput)) {
            return false;
        }
        MetricAttributionOutput other = (MetricAttributionOutput)obj;
        return Objects.equals(this.s3DataDestination(), other.s3DataDestination()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public final String toString() {
        return ToString.builder((String)"MetricAttributionOutput").add("S3DataDestination", (Object)this.s3DataDestination()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "s3DataDestination": {
                return Optional.ofNullable(clazz.cast(this.s3DataDestination()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MetricAttributionOutput, T> g) {
        return obj -> g.apply((MetricAttributionOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private S3DataConfig s3DataDestination;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricAttributionOutput model) {
            this.s3DataDestination(model.s3DataDestination);
            this.roleArn(model.roleArn);
        }

        public final S3DataConfig.Builder getS3DataDestination() {
            return this.s3DataDestination != null ? this.s3DataDestination.toBuilder() : null;
        }

        public final void setS3DataDestination(S3DataConfig.BuilderImpl s3DataDestination) {
            this.s3DataDestination = s3DataDestination != null ? s3DataDestination.build() : null;
        }

        @Override
        public final Builder s3DataDestination(S3DataConfig s3DataDestination) {
            this.s3DataDestination = s3DataDestination;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public MetricAttributionOutput build() {
            return new MetricAttributionOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricAttributionOutput> {
        public Builder s3DataDestination(S3DataConfig var1);

        default public Builder s3DataDestination(Consumer<S3DataConfig.Builder> s3DataDestination) {
            return this.s3DataDestination((S3DataConfig)((S3DataConfig.Builder)S3DataConfig.builder().applyMutation(s3DataDestination)).build());
        }

        public Builder roleArn(String var1);
    }
}

