/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.personalize.model.MetricAttribute;
import software.amazon.awssdk.services.personalize.model.MetricAttributesCopier;
import software.amazon.awssdk.services.personalize.model.MetricAttributionOutput;
import software.amazon.awssdk.services.personalize.model.PersonalizeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMetricAttributionRequest
extends PersonalizeRequest
implements ToCopyableBuilder<Builder, CreateMetricAttributionRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateMetricAttributionRequest.getter(CreateMetricAttributionRequest::name)).setter(CreateMetricAttributionRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DATASET_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetGroupArn").getter(CreateMetricAttributionRequest.getter(CreateMetricAttributionRequest::datasetGroupArn)).setter(CreateMetricAttributionRequest.setter(Builder::datasetGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetGroupArn").build()}).build();
    private static final SdkField<List<MetricAttribute>> METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metrics").getter(CreateMetricAttributionRequest.getter(CreateMetricAttributionRequest::metrics)).setter(CreateMetricAttributionRequest.setter(Builder::metrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<MetricAttributionOutput> METRICS_OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metricsOutputConfig").getter(CreateMetricAttributionRequest.getter(CreateMetricAttributionRequest::metricsOutputConfig)).setter(CreateMetricAttributionRequest.setter(Builder::metricsOutputConfig)).constructor(MetricAttributionOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsOutputConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DATASET_GROUP_ARN_FIELD, METRICS_FIELD, METRICS_OUTPUT_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("datasetGroupArn", DATASET_GROUP_ARN_FIELD);
            this.put("metrics", METRICS_FIELD);
            this.put("metricsOutputConfig", METRICS_OUTPUT_CONFIG_FIELD);
        }
    });
    private final String name;
    private final String datasetGroupArn;
    private final List<MetricAttribute> metrics;
    private final MetricAttributionOutput metricsOutputConfig;

    private CreateMetricAttributionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.datasetGroupArn = builder.datasetGroupArn;
        this.metrics = builder.metrics;
        this.metricsOutputConfig = builder.metricsOutputConfig;
    }

    public final String name() {
        return this.name;
    }

    public final String datasetGroupArn() {
        return this.datasetGroupArn;
    }

    public final boolean hasMetrics() {
        return this.metrics != null && !(this.metrics instanceof SdkAutoConstructList);
    }

    public final List<MetricAttribute> metrics() {
        return this.metrics;
    }

    public final MetricAttributionOutput metricsOutputConfig() {
        return this.metricsOutputConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetrics() ? this.metrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.metricsOutputConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMetricAttributionRequest)) {
            return false;
        }
        CreateMetricAttributionRequest other = (CreateMetricAttributionRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.datasetGroupArn(), other.datasetGroupArn()) && this.hasMetrics() == other.hasMetrics() && Objects.equals(this.metrics(), other.metrics()) && Objects.equals(this.metricsOutputConfig(), other.metricsOutputConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMetricAttributionRequest").add("Name", (Object)this.name()).add("DatasetGroupArn", (Object)this.datasetGroupArn()).add("Metrics", this.hasMetrics() ? this.metrics() : null).add("MetricsOutputConfig", (Object)this.metricsOutputConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "datasetGroupArn": {
                return Optional.ofNullable(clazz.cast(this.datasetGroupArn()));
            }
            case "metrics": {
                return Optional.ofNullable(clazz.cast(this.metrics()));
            }
            case "metricsOutputConfig": {
                return Optional.ofNullable(clazz.cast(this.metricsOutputConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateMetricAttributionRequest, T> g) {
        return obj -> g.apply((CreateMetricAttributionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PersonalizeRequest.BuilderImpl
    implements Builder {
        private String name;
        private String datasetGroupArn;
        private List<MetricAttribute> metrics = DefaultSdkAutoConstructList.getInstance();
        private MetricAttributionOutput metricsOutputConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMetricAttributionRequest model) {
            super(model);
            this.name(model.name);
            this.datasetGroupArn(model.datasetGroupArn);
            this.metrics(model.metrics);
            this.metricsOutputConfig(model.metricsOutputConfig);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDatasetGroupArn() {
            return this.datasetGroupArn;
        }

        public final void setDatasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
        }

        @Override
        public final Builder datasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
            return this;
        }

        public final List<MetricAttribute.Builder> getMetrics() {
            List<MetricAttribute.Builder> result = MetricAttributesCopier.copyToBuilder(this.metrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetrics(Collection<MetricAttribute.BuilderImpl> metrics) {
            this.metrics = MetricAttributesCopier.copyFromBuilder(metrics);
        }

        @Override
        public final Builder metrics(Collection<MetricAttribute> metrics) {
            this.metrics = MetricAttributesCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(MetricAttribute ... metrics) {
            this.metrics(Arrays.asList(metrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(Consumer<MetricAttribute.Builder> ... metrics) {
            this.metrics(Stream.of(metrics).map(c -> (MetricAttribute)((MetricAttribute.Builder)MetricAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final MetricAttributionOutput.Builder getMetricsOutputConfig() {
            return this.metricsOutputConfig != null ? this.metricsOutputConfig.toBuilder() : null;
        }

        public final void setMetricsOutputConfig(MetricAttributionOutput.BuilderImpl metricsOutputConfig) {
            this.metricsOutputConfig = metricsOutputConfig != null ? metricsOutputConfig.build() : null;
        }

        @Override
        public final Builder metricsOutputConfig(MetricAttributionOutput metricsOutputConfig) {
            this.metricsOutputConfig = metricsOutputConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMetricAttributionRequest build() {
            return new CreateMetricAttributionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PersonalizeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMetricAttributionRequest> {
        public Builder name(String var1);

        public Builder datasetGroupArn(String var1);

        public Builder metrics(Collection<MetricAttribute> var1);

        public Builder metrics(MetricAttribute ... var1);

        public Builder metrics(Consumer<MetricAttribute.Builder> ... var1);

        public Builder metricsOutputConfig(MetricAttributionOutput var1);

        default public Builder metricsOutputConfig(Consumer<MetricAttributionOutput.Builder> metricsOutputConfig) {
            return this.metricsOutputConfig((MetricAttributionOutput)((MetricAttributionOutput.Builder)MetricAttributionOutput.builder().applyMutation(metricsOutputConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

