/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.personalize.DefaultPersonalizeBaseClientBuilder;
import software.amazon.awssdk.services.personalize.DefaultPersonalizeClient;
import software.amazon.awssdk.services.personalize.PersonalizeClient;
import software.amazon.awssdk.services.personalize.PersonalizeClientBuilder;
import software.amazon.awssdk.services.personalize.PersonalizeServiceClientConfiguration;
import software.amazon.awssdk.services.personalize.endpoints.PersonalizeEndpointProvider;

@SdkInternalApi
final class DefaultPersonalizeClientBuilder
extends DefaultPersonalizeBaseClientBuilder<PersonalizeClientBuilder, PersonalizeClient>
implements PersonalizeClientBuilder {
    DefaultPersonalizeClientBuilder() {
    }

    @Override
    public DefaultPersonalizeClientBuilder endpointProvider(PersonalizeEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final PersonalizeClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultPersonalizeClientBuilder.validateClientOptions(clientConfiguration);
        PersonalizeServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultPersonalizeClient client = new DefaultPersonalizeClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private PersonalizeServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return PersonalizeServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

