/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.personalize.PersonalizeClient;
import software.amazon.awssdk.services.personalize.model.BatchSegmentJobSummary;
import software.amazon.awssdk.services.personalize.model.ListBatchSegmentJobsRequest;
import software.amazon.awssdk.services.personalize.model.ListBatchSegmentJobsResponse;

public class ListBatchSegmentJobsIterable
implements SdkIterable<ListBatchSegmentJobsResponse> {
    private final PersonalizeClient client;
    private final ListBatchSegmentJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBatchSegmentJobsIterable(PersonalizeClient client, ListBatchSegmentJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListBatchSegmentJobsResponseFetcher();
    }

    public Iterator<ListBatchSegmentJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<BatchSegmentJobSummary> batchSegmentJobs() {
        Function<ListBatchSegmentJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.batchSegmentJobs() != null) {
                return response.batchSegmentJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListBatchSegmentJobsResponseFetcher
    implements SyncPageFetcher<ListBatchSegmentJobsResponse> {
        private ListBatchSegmentJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListBatchSegmentJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBatchSegmentJobsResponse nextPage(ListBatchSegmentJobsResponse previousPage) {
            if (previousPage == null) {
                return ListBatchSegmentJobsIterable.this.client.listBatchSegmentJobs(ListBatchSegmentJobsIterable.this.firstRequest);
            }
            return ListBatchSegmentJobsIterable.this.client.listBatchSegmentJobs((ListBatchSegmentJobsRequest)((Object)ListBatchSegmentJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

