/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ObjectiveSensitivity {
    LOW("LOW"),
    MEDIUM("MEDIUM"),
    HIGH("HIGH"),
    OFF("OFF"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ObjectiveSensitivity> VALUE_MAP;
    private final String value;

    private ObjectiveSensitivity(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ObjectiveSensitivity fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ObjectiveSensitivity> knownValues() {
        EnumSet<ObjectiveSensitivity> knownValues = EnumSet.allOf(ObjectiveSensitivity.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ObjectiveSensitivity.class, ObjectiveSensitivity::toString);
    }
}

