/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.personalize.model.MetricAttribute;
import software.amazon.awssdk.services.personalize.model.MetricAttributesCopier;
import software.amazon.awssdk.services.personalize.model.PersonalizeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMetricAttributionMetricsResponse
extends PersonalizeResponse
implements ToCopyableBuilder<Builder, ListMetricAttributionMetricsResponse> {
    private static final SdkField<List<MetricAttribute>> METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metrics").getter(ListMetricAttributionMetricsResponse.getter(ListMetricAttributionMetricsResponse::metrics)).setter(ListMetricAttributionMetricsResponse.setter(Builder::metrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListMetricAttributionMetricsResponse.getter(ListMetricAttributionMetricsResponse::nextToken)).setter(ListMetricAttributionMetricsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRICS_FIELD, NEXT_TOKEN_FIELD));
    private final List<MetricAttribute> metrics;
    private final String nextToken;

    private ListMetricAttributionMetricsResponse(BuilderImpl builder) {
        super(builder);
        this.metrics = builder.metrics;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasMetrics() {
        return this.metrics != null && !(this.metrics instanceof SdkAutoConstructList);
    }

    public final List<MetricAttribute> metrics() {
        return this.metrics;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetrics() ? this.metrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMetricAttributionMetricsResponse)) {
            return false;
        }
        ListMetricAttributionMetricsResponse other = (ListMetricAttributionMetricsResponse)((Object)obj);
        return this.hasMetrics() == other.hasMetrics() && Objects.equals(this.metrics(), other.metrics()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListMetricAttributionMetricsResponse").add("Metrics", this.hasMetrics() ? this.metrics() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "metrics": {
                return Optional.ofNullable(clazz.cast(this.metrics()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMetricAttributionMetricsResponse, T> g) {
        return obj -> g.apply((ListMetricAttributionMetricsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PersonalizeResponse.BuilderImpl
    implements Builder {
        private List<MetricAttribute> metrics = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMetricAttributionMetricsResponse model) {
            super(model);
            this.metrics(model.metrics);
            this.nextToken(model.nextToken);
        }

        public final List<MetricAttribute.Builder> getMetrics() {
            List<MetricAttribute.Builder> result = MetricAttributesCopier.copyToBuilder(this.metrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetrics(Collection<MetricAttribute.BuilderImpl> metrics) {
            this.metrics = MetricAttributesCopier.copyFromBuilder(metrics);
        }

        @Override
        public final Builder metrics(Collection<MetricAttribute> metrics) {
            this.metrics = MetricAttributesCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(MetricAttribute ... metrics) {
            this.metrics(Arrays.asList(metrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(Consumer<MetricAttribute.Builder> ... metrics) {
            this.metrics(Stream.of(metrics).map(c -> (MetricAttribute)((MetricAttribute.Builder)MetricAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMetricAttributionMetricsResponse build() {
            return new ListMetricAttributionMetricsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PersonalizeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMetricAttributionMetricsResponse> {
        public Builder metrics(Collection<MetricAttribute> var1);

        public Builder metrics(MetricAttribute ... var1);

        public Builder metrics(Consumer<MetricAttribute.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

