/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCampaignResponse extends PersonalizeResponse implements
        ToCopyableBuilder<UpdateCampaignResponse.Builder, UpdateCampaignResponse> {
    private static final SdkField<String> CAMPAIGN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("campaignArn").getter(getter(UpdateCampaignResponse::campaignArn)).setter(setter(Builder::campaignArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("campaignArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAMPAIGN_ARN_FIELD));

    private final String campaignArn;

    private UpdateCampaignResponse(BuilderImpl builder) {
        super(builder);
        this.campaignArn = builder.campaignArn;
    }

    /**
     * <p>
     * The same campaign ARN as given in the request.
     * </p>
     * 
     * @return The same campaign ARN as given in the request.
     */
    public final String campaignArn() {
        return campaignArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(campaignArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCampaignResponse)) {
            return false;
        }
        UpdateCampaignResponse other = (UpdateCampaignResponse) obj;
        return Objects.equals(campaignArn(), other.campaignArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateCampaignResponse").add("CampaignArn", campaignArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "campaignArn":
            return Optional.ofNullable(clazz.cast(campaignArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCampaignResponse, T> g) {
        return obj -> g.apply((UpdateCampaignResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateCampaignResponse> {
        /**
         * <p>
         * The same campaign ARN as given in the request.
         * </p>
         * 
         * @param campaignArn
         *        The same campaign ARN as given in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder campaignArn(String campaignArn);
    }

    static final class BuilderImpl extends PersonalizeResponse.BuilderImpl implements Builder {
        private String campaignArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCampaignResponse model) {
            super(model);
            campaignArn(model.campaignArn);
        }

        public final String getCampaignArn() {
            return campaignArn;
        }

        public final void setCampaignArn(String campaignArn) {
            this.campaignArn = campaignArn;
        }

        @Override
        public final Builder campaignArn(String campaignArn) {
            this.campaignArn = campaignArn;
            return this;
        }

        @Override
        public UpdateCampaignResponse build() {
            return new UpdateCampaignResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
