/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an algorithm image.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AlgorithmImage implements SdkPojo, Serializable, ToCopyableBuilder<AlgorithmImage.Builder, AlgorithmImage> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AlgorithmImage::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DOCKER_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dockerURI").getter(getter(AlgorithmImage::dockerURI)).setter(setter(Builder::dockerURI))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dockerURI").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DOCKER_URI_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String dockerURI;

    private AlgorithmImage(BuilderImpl builder) {
        this.name = builder.name;
        this.dockerURI = builder.dockerURI;
    }

    /**
     * <p>
     * The name of the algorithm image.
     * </p>
     * 
     * @return The name of the algorithm image.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The URI of the Docker container for the algorithm image.
     * </p>
     * 
     * @return The URI of the Docker container for the algorithm image.
     */
    public final String dockerURI() {
        return dockerURI;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(dockerURI());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlgorithmImage)) {
            return false;
        }
        AlgorithmImage other = (AlgorithmImage) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(dockerURI(), other.dockerURI());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AlgorithmImage").add("Name", name()).add("DockerURI", dockerURI()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "dockerURI":
            return Optional.ofNullable(clazz.cast(dockerURI()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AlgorithmImage, T> g) {
        return obj -> g.apply((AlgorithmImage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AlgorithmImage> {
        /**
         * <p>
         * The name of the algorithm image.
         * </p>
         * 
         * @param name
         *        The name of the algorithm image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The URI of the Docker container for the algorithm image.
         * </p>
         * 
         * @param dockerURI
         *        The URI of the Docker container for the algorithm image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dockerURI(String dockerURI);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String dockerURI;

        private BuilderImpl() {
        }

        private BuilderImpl(AlgorithmImage model) {
            name(model.name);
            dockerURI(model.dockerURI);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDockerURI() {
            return dockerURI;
        }

        public final void setDockerURI(String dockerURI) {
            this.dockerURI = dockerURI;
        }

        @Override
        public final Builder dockerURI(String dockerURI) {
            this.dockerURI = dockerURI;
            return this;
        }

        @Override
        public AlgorithmImage build() {
            return new AlgorithmImage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
