/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.personalize.model.CampaignConfig;
import software.amazon.awssdk.services.personalize.model.PersonalizeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCampaignRequest
extends PersonalizeRequest
implements ToCopyableBuilder<Builder, CreateCampaignRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateCampaignRequest.getter(CreateCampaignRequest::name)).setter(CreateCampaignRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> SOLUTION_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("solutionVersionArn").getter(CreateCampaignRequest.getter(CreateCampaignRequest::solutionVersionArn)).setter(CreateCampaignRequest.setter(Builder::solutionVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionVersionArn").build()}).build();
    private static final SdkField<Integer> MIN_PROVISIONED_TPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("minProvisionedTPS").getter(CreateCampaignRequest.getter(CreateCampaignRequest::minProvisionedTPS)).setter(CreateCampaignRequest.setter(Builder::minProvisionedTPS)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minProvisionedTPS").build()}).build();
    private static final SdkField<CampaignConfig> CAMPAIGN_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("campaignConfig").getter(CreateCampaignRequest.getter(CreateCampaignRequest::campaignConfig)).setter(CreateCampaignRequest.setter(Builder::campaignConfig)).constructor(CampaignConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("campaignConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SOLUTION_VERSION_ARN_FIELD, MIN_PROVISIONED_TPS_FIELD, CAMPAIGN_CONFIG_FIELD));
    private final String name;
    private final String solutionVersionArn;
    private final Integer minProvisionedTPS;
    private final CampaignConfig campaignConfig;

    private CreateCampaignRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.solutionVersionArn = builder.solutionVersionArn;
        this.minProvisionedTPS = builder.minProvisionedTPS;
        this.campaignConfig = builder.campaignConfig;
    }

    public final String name() {
        return this.name;
    }

    public final String solutionVersionArn() {
        return this.solutionVersionArn;
    }

    public final Integer minProvisionedTPS() {
        return this.minProvisionedTPS;
    }

    public final CampaignConfig campaignConfig() {
        return this.campaignConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.solutionVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.minProvisionedTPS());
        hashCode = 31 * hashCode + Objects.hashCode(this.campaignConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCampaignRequest)) {
            return false;
        }
        CreateCampaignRequest other = (CreateCampaignRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.solutionVersionArn(), other.solutionVersionArn()) && Objects.equals(this.minProvisionedTPS(), other.minProvisionedTPS()) && Objects.equals(this.campaignConfig(), other.campaignConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCampaignRequest").add("Name", (Object)this.name()).add("SolutionVersionArn", (Object)this.solutionVersionArn()).add("MinProvisionedTPS", (Object)this.minProvisionedTPS()).add("CampaignConfig", (Object)this.campaignConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "solutionVersionArn": {
                return Optional.ofNullable(clazz.cast(this.solutionVersionArn()));
            }
            case "minProvisionedTPS": {
                return Optional.ofNullable(clazz.cast(this.minProvisionedTPS()));
            }
            case "campaignConfig": {
                return Optional.ofNullable(clazz.cast(this.campaignConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCampaignRequest, T> g) {
        return obj -> g.apply((CreateCampaignRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PersonalizeRequest.BuilderImpl
    implements Builder {
        private String name;
        private String solutionVersionArn;
        private Integer minProvisionedTPS;
        private CampaignConfig campaignConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCampaignRequest model) {
            super(model);
            this.name(model.name);
            this.solutionVersionArn(model.solutionVersionArn);
            this.minProvisionedTPS(model.minProvisionedTPS);
            this.campaignConfig(model.campaignConfig);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSolutionVersionArn() {
            return this.solutionVersionArn;
        }

        public final void setSolutionVersionArn(String solutionVersionArn) {
            this.solutionVersionArn = solutionVersionArn;
        }

        @Override
        @Transient
        public final Builder solutionVersionArn(String solutionVersionArn) {
            this.solutionVersionArn = solutionVersionArn;
            return this;
        }

        public final Integer getMinProvisionedTPS() {
            return this.minProvisionedTPS;
        }

        public final void setMinProvisionedTPS(Integer minProvisionedTPS) {
            this.minProvisionedTPS = minProvisionedTPS;
        }

        @Override
        @Transient
        public final Builder minProvisionedTPS(Integer minProvisionedTPS) {
            this.minProvisionedTPS = minProvisionedTPS;
            return this;
        }

        public final CampaignConfig.Builder getCampaignConfig() {
            return this.campaignConfig != null ? this.campaignConfig.toBuilder() : null;
        }

        public final void setCampaignConfig(CampaignConfig.BuilderImpl campaignConfig) {
            this.campaignConfig = campaignConfig != null ? campaignConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder campaignConfig(CampaignConfig campaignConfig) {
            this.campaignConfig = campaignConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCampaignRequest build() {
            return new CreateCampaignRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PersonalizeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCampaignRequest> {
        public Builder name(String var1);

        public Builder solutionVersionArn(String var1);

        public Builder minProvisionedTPS(Integer var1);

        public Builder campaignConfig(CampaignConfig var1);

        default public Builder campaignConfig(Consumer<CampaignConfig.Builder> campaignConfig) {
            return this.campaignConfig((CampaignConfig)((CampaignConfig.Builder)CampaignConfig.builder().applyMutation(campaignConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

