/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.personalize.model.PersonalizeResponse;
import software.amazon.awssdk.services.personalize.model.RecipeSummary;
import software.amazon.awssdk.services.personalize.model.RecipesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRecipesResponse
extends PersonalizeResponse
implements ToCopyableBuilder<Builder, ListRecipesResponse> {
    private static final SdkField<List<RecipeSummary>> RECIPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("recipes").getter(ListRecipesResponse.getter(ListRecipesResponse::recipes)).setter(ListRecipesResponse.setter(Builder::recipes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recipes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecipeSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListRecipesResponse.getter(ListRecipesResponse::nextToken)).setter(ListRecipesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECIPES_FIELD, NEXT_TOKEN_FIELD));
    private final List<RecipeSummary> recipes;
    private final String nextToken;

    private ListRecipesResponse(BuilderImpl builder) {
        super(builder);
        this.recipes = builder.recipes;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRecipes() {
        return this.recipes != null && !(this.recipes instanceof SdkAutoConstructList);
    }

    public final List<RecipeSummary> recipes() {
        return this.recipes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecipes() ? this.recipes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecipesResponse)) {
            return false;
        }
        ListRecipesResponse other = (ListRecipesResponse)((Object)obj);
        return this.hasRecipes() == other.hasRecipes() && Objects.equals(this.recipes(), other.recipes()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRecipesResponse").add("Recipes", this.hasRecipes() ? this.recipes() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "recipes": {
                return Optional.ofNullable(clazz.cast(this.recipes()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRecipesResponse, T> g) {
        return obj -> g.apply((ListRecipesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PersonalizeResponse.BuilderImpl
    implements Builder {
        private List<RecipeSummary> recipes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecipesResponse model) {
            super(model);
            this.recipes(model.recipes);
            this.nextToken(model.nextToken);
        }

        public final List<RecipeSummary.Builder> getRecipes() {
            List<RecipeSummary.Builder> result = RecipesCopier.copyToBuilder(this.recipes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder recipes(Collection<RecipeSummary> recipes) {
            this.recipes = RecipesCopier.copy(recipes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recipes(RecipeSummary ... recipes) {
            this.recipes(Arrays.asList(recipes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recipes(Consumer<RecipeSummary.Builder> ... recipes) {
            this.recipes(Stream.of(recipes).map(c -> (RecipeSummary)((RecipeSummary.Builder)RecipeSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecipes(Collection<RecipeSummary.BuilderImpl> recipes) {
            this.recipes = RecipesCopier.copyFromBuilder(recipes);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListRecipesResponse build() {
            return new ListRecipesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PersonalizeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRecipesResponse> {
        public Builder recipes(Collection<RecipeSummary> var1);

        public Builder recipes(RecipeSummary ... var1);

        public Builder recipes(Consumer<RecipeSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

