/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum IngestionMode {
    BULK("BULK"),
    PUT("PUT"),
    ALL("ALL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private IngestionMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IngestionMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(IngestionMode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IngestionMode> knownValues() {
        return Stream.of(IngestionMode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

