/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.personalize.model.PersonalizeRequest;
import software.amazon.awssdk.services.personalize.model.TrainingMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSolutionVersionRequest
extends PersonalizeRequest
implements ToCopyableBuilder<Builder, CreateSolutionVersionRequest> {
    private static final SdkField<String> SOLUTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("solutionArn").getter(CreateSolutionVersionRequest.getter(CreateSolutionVersionRequest::solutionArn)).setter(CreateSolutionVersionRequest.setter(Builder::solutionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionArn").build()}).build();
    private static final SdkField<String> TRAINING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trainingMode").getter(CreateSolutionVersionRequest.getter(CreateSolutionVersionRequest::trainingModeAsString)).setter(CreateSolutionVersionRequest.setter(Builder::trainingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOLUTION_ARN_FIELD, TRAINING_MODE_FIELD));
    private final String solutionArn;
    private final String trainingMode;

    private CreateSolutionVersionRequest(BuilderImpl builder) {
        super(builder);
        this.solutionArn = builder.solutionArn;
        this.trainingMode = builder.trainingMode;
    }

    public final String solutionArn() {
        return this.solutionArn;
    }

    public final TrainingMode trainingMode() {
        return TrainingMode.fromValue(this.trainingMode);
    }

    public final String trainingModeAsString() {
        return this.trainingMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.solutionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSolutionVersionRequest)) {
            return false;
        }
        CreateSolutionVersionRequest other = (CreateSolutionVersionRequest)((Object)obj);
        return Objects.equals(this.solutionArn(), other.solutionArn()) && Objects.equals(this.trainingModeAsString(), other.trainingModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSolutionVersionRequest").add("SolutionArn", (Object)this.solutionArn()).add("TrainingMode", (Object)this.trainingModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "solutionArn": {
                return Optional.ofNullable(clazz.cast(this.solutionArn()));
            }
            case "trainingMode": {
                return Optional.ofNullable(clazz.cast(this.trainingModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSolutionVersionRequest, T> g) {
        return obj -> g.apply((CreateSolutionVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PersonalizeRequest.BuilderImpl
    implements Builder {
        private String solutionArn;
        private String trainingMode;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSolutionVersionRequest model) {
            super(model);
            this.solutionArn(model.solutionArn);
            this.trainingMode(model.trainingMode);
        }

        public final String getSolutionArn() {
            return this.solutionArn;
        }

        @Override
        public final Builder solutionArn(String solutionArn) {
            this.solutionArn = solutionArn;
            return this;
        }

        public final void setSolutionArn(String solutionArn) {
            this.solutionArn = solutionArn;
        }

        public final String getTrainingMode() {
            return this.trainingMode;
        }

        @Override
        public final Builder trainingMode(String trainingMode) {
            this.trainingMode = trainingMode;
            return this;
        }

        @Override
        public final Builder trainingMode(TrainingMode trainingMode) {
            this.trainingMode(trainingMode == null ? null : trainingMode.toString());
            return this;
        }

        public final void setTrainingMode(String trainingMode) {
            this.trainingMode = trainingMode;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSolutionVersionRequest build() {
            return new CreateSolutionVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PersonalizeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSolutionVersionRequest> {
        public Builder solutionArn(String var1);

        public Builder trainingMode(String var1);

        public Builder trainingMode(TrainingMode var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

