/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.personalize.model.CategoricalHyperParameterRange;
import software.amazon.awssdk.services.personalize.model.CategoricalHyperParameterRangesCopier;
import software.amazon.awssdk.services.personalize.model.ContinuousHyperParameterRange;
import software.amazon.awssdk.services.personalize.model.ContinuousHyperParameterRangesCopier;
import software.amazon.awssdk.services.personalize.model.IntegerHyperParameterRange;
import software.amazon.awssdk.services.personalize.model.IntegerHyperParameterRangesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HyperParameterRanges
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HyperParameterRanges> {
    private static final SdkField<List<IntegerHyperParameterRange>> INTEGER_HYPER_PARAMETER_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("integerHyperParameterRanges").getter(HyperParameterRanges.getter(HyperParameterRanges::integerHyperParameterRanges)).setter(HyperParameterRanges.setter(Builder::integerHyperParameterRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integerHyperParameterRanges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IntegerHyperParameterRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ContinuousHyperParameterRange>> CONTINUOUS_HYPER_PARAMETER_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("continuousHyperParameterRanges").getter(HyperParameterRanges.getter(HyperParameterRanges::continuousHyperParameterRanges)).setter(HyperParameterRanges.setter(Builder::continuousHyperParameterRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("continuousHyperParameterRanges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContinuousHyperParameterRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CategoricalHyperParameterRange>> CATEGORICAL_HYPER_PARAMETER_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("categoricalHyperParameterRanges").getter(HyperParameterRanges.getter(HyperParameterRanges::categoricalHyperParameterRanges)).setter(HyperParameterRanges.setter(Builder::categoricalHyperParameterRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("categoricalHyperParameterRanges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CategoricalHyperParameterRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGER_HYPER_PARAMETER_RANGES_FIELD, CONTINUOUS_HYPER_PARAMETER_RANGES_FIELD, CATEGORICAL_HYPER_PARAMETER_RANGES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<IntegerHyperParameterRange> integerHyperParameterRanges;
    private final List<ContinuousHyperParameterRange> continuousHyperParameterRanges;
    private final List<CategoricalHyperParameterRange> categoricalHyperParameterRanges;

    private HyperParameterRanges(BuilderImpl builder) {
        this.integerHyperParameterRanges = builder.integerHyperParameterRanges;
        this.continuousHyperParameterRanges = builder.continuousHyperParameterRanges;
        this.categoricalHyperParameterRanges = builder.categoricalHyperParameterRanges;
    }

    public final boolean hasIntegerHyperParameterRanges() {
        return this.integerHyperParameterRanges != null && !(this.integerHyperParameterRanges instanceof SdkAutoConstructList);
    }

    public final List<IntegerHyperParameterRange> integerHyperParameterRanges() {
        return this.integerHyperParameterRanges;
    }

    public final boolean hasContinuousHyperParameterRanges() {
        return this.continuousHyperParameterRanges != null && !(this.continuousHyperParameterRanges instanceof SdkAutoConstructList);
    }

    public final List<ContinuousHyperParameterRange> continuousHyperParameterRanges() {
        return this.continuousHyperParameterRanges;
    }

    public final boolean hasCategoricalHyperParameterRanges() {
        return this.categoricalHyperParameterRanges != null && !(this.categoricalHyperParameterRanges instanceof SdkAutoConstructList);
    }

    public final List<CategoricalHyperParameterRange> categoricalHyperParameterRanges() {
        return this.categoricalHyperParameterRanges;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIntegerHyperParameterRanges() ? this.integerHyperParameterRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContinuousHyperParameterRanges() ? this.continuousHyperParameterRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCategoricalHyperParameterRanges() ? this.categoricalHyperParameterRanges() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HyperParameterRanges)) {
            return false;
        }
        HyperParameterRanges other = (HyperParameterRanges)obj;
        return this.hasIntegerHyperParameterRanges() == other.hasIntegerHyperParameterRanges() && Objects.equals(this.integerHyperParameterRanges(), other.integerHyperParameterRanges()) && this.hasContinuousHyperParameterRanges() == other.hasContinuousHyperParameterRanges() && Objects.equals(this.continuousHyperParameterRanges(), other.continuousHyperParameterRanges()) && this.hasCategoricalHyperParameterRanges() == other.hasCategoricalHyperParameterRanges() && Objects.equals(this.categoricalHyperParameterRanges(), other.categoricalHyperParameterRanges());
    }

    public final String toString() {
        return ToString.builder((String)"HyperParameterRanges").add("IntegerHyperParameterRanges", this.hasIntegerHyperParameterRanges() ? this.integerHyperParameterRanges() : null).add("ContinuousHyperParameterRanges", this.hasContinuousHyperParameterRanges() ? this.continuousHyperParameterRanges() : null).add("CategoricalHyperParameterRanges", this.hasCategoricalHyperParameterRanges() ? this.categoricalHyperParameterRanges() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "integerHyperParameterRanges": {
                return Optional.ofNullable(clazz.cast(this.integerHyperParameterRanges()));
            }
            case "continuousHyperParameterRanges": {
                return Optional.ofNullable(clazz.cast(this.continuousHyperParameterRanges()));
            }
            case "categoricalHyperParameterRanges": {
                return Optional.ofNullable(clazz.cast(this.categoricalHyperParameterRanges()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HyperParameterRanges, T> g) {
        return obj -> g.apply((HyperParameterRanges)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<IntegerHyperParameterRange> integerHyperParameterRanges = DefaultSdkAutoConstructList.getInstance();
        private List<ContinuousHyperParameterRange> continuousHyperParameterRanges = DefaultSdkAutoConstructList.getInstance();
        private List<CategoricalHyperParameterRange> categoricalHyperParameterRanges = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HyperParameterRanges model) {
            this.integerHyperParameterRanges(model.integerHyperParameterRanges);
            this.continuousHyperParameterRanges(model.continuousHyperParameterRanges);
            this.categoricalHyperParameterRanges(model.categoricalHyperParameterRanges);
        }

        public final Collection<IntegerHyperParameterRange.Builder> getIntegerHyperParameterRanges() {
            if (this.integerHyperParameterRanges instanceof SdkAutoConstructList) {
                return null;
            }
            return this.integerHyperParameterRanges != null ? (Collection)this.integerHyperParameterRanges.stream().map(IntegerHyperParameterRange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder integerHyperParameterRanges(Collection<IntegerHyperParameterRange> integerHyperParameterRanges) {
            this.integerHyperParameterRanges = IntegerHyperParameterRangesCopier.copy(integerHyperParameterRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integerHyperParameterRanges(IntegerHyperParameterRange ... integerHyperParameterRanges) {
            this.integerHyperParameterRanges(Arrays.asList(integerHyperParameterRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integerHyperParameterRanges(Consumer<IntegerHyperParameterRange.Builder> ... integerHyperParameterRanges) {
            this.integerHyperParameterRanges(Stream.of(integerHyperParameterRanges).map(c -> (IntegerHyperParameterRange)((IntegerHyperParameterRange.Builder)IntegerHyperParameterRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIntegerHyperParameterRanges(Collection<IntegerHyperParameterRange.BuilderImpl> integerHyperParameterRanges) {
            this.integerHyperParameterRanges = IntegerHyperParameterRangesCopier.copyFromBuilder(integerHyperParameterRanges);
        }

        public final Collection<ContinuousHyperParameterRange.Builder> getContinuousHyperParameterRanges() {
            if (this.continuousHyperParameterRanges instanceof SdkAutoConstructList) {
                return null;
            }
            return this.continuousHyperParameterRanges != null ? (Collection)this.continuousHyperParameterRanges.stream().map(ContinuousHyperParameterRange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder continuousHyperParameterRanges(Collection<ContinuousHyperParameterRange> continuousHyperParameterRanges) {
            this.continuousHyperParameterRanges = ContinuousHyperParameterRangesCopier.copy(continuousHyperParameterRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder continuousHyperParameterRanges(ContinuousHyperParameterRange ... continuousHyperParameterRanges) {
            this.continuousHyperParameterRanges(Arrays.asList(continuousHyperParameterRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder continuousHyperParameterRanges(Consumer<ContinuousHyperParameterRange.Builder> ... continuousHyperParameterRanges) {
            this.continuousHyperParameterRanges(Stream.of(continuousHyperParameterRanges).map(c -> (ContinuousHyperParameterRange)((ContinuousHyperParameterRange.Builder)ContinuousHyperParameterRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setContinuousHyperParameterRanges(Collection<ContinuousHyperParameterRange.BuilderImpl> continuousHyperParameterRanges) {
            this.continuousHyperParameterRanges = ContinuousHyperParameterRangesCopier.copyFromBuilder(continuousHyperParameterRanges);
        }

        public final Collection<CategoricalHyperParameterRange.Builder> getCategoricalHyperParameterRanges() {
            if (this.categoricalHyperParameterRanges instanceof SdkAutoConstructList) {
                return null;
            }
            return this.categoricalHyperParameterRanges != null ? (Collection)this.categoricalHyperParameterRanges.stream().map(CategoricalHyperParameterRange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder categoricalHyperParameterRanges(Collection<CategoricalHyperParameterRange> categoricalHyperParameterRanges) {
            this.categoricalHyperParameterRanges = CategoricalHyperParameterRangesCopier.copy(categoricalHyperParameterRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categoricalHyperParameterRanges(CategoricalHyperParameterRange ... categoricalHyperParameterRanges) {
            this.categoricalHyperParameterRanges(Arrays.asList(categoricalHyperParameterRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categoricalHyperParameterRanges(Consumer<CategoricalHyperParameterRange.Builder> ... categoricalHyperParameterRanges) {
            this.categoricalHyperParameterRanges(Stream.of(categoricalHyperParameterRanges).map(c -> (CategoricalHyperParameterRange)((CategoricalHyperParameterRange.Builder)CategoricalHyperParameterRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCategoricalHyperParameterRanges(Collection<CategoricalHyperParameterRange.BuilderImpl> categoricalHyperParameterRanges) {
            this.categoricalHyperParameterRanges = CategoricalHyperParameterRangesCopier.copyFromBuilder(categoricalHyperParameterRanges);
        }

        public HyperParameterRanges build() {
            return new HyperParameterRanges(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HyperParameterRanges> {
        public Builder integerHyperParameterRanges(Collection<IntegerHyperParameterRange> var1);

        public Builder integerHyperParameterRanges(IntegerHyperParameterRange ... var1);

        public Builder integerHyperParameterRanges(Consumer<IntegerHyperParameterRange.Builder> ... var1);

        public Builder continuousHyperParameterRanges(Collection<ContinuousHyperParameterRange> var1);

        public Builder continuousHyperParameterRanges(ContinuousHyperParameterRange ... var1);

        public Builder continuousHyperParameterRanges(Consumer<ContinuousHyperParameterRange.Builder> ... var1);

        public Builder categoricalHyperParameterRanges(Collection<CategoricalHyperParameterRange> var1);

        public Builder categoricalHyperParameterRanges(CategoricalHyperParameterRange ... var1);

        public Builder categoricalHyperParameterRanges(Consumer<CategoricalHyperParameterRange.Builder> ... var1);
    }
}

