/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.personalize.model.PersonalizeResponse;
import software.amazon.awssdk.services.personalize.model.SolutionVersion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSolutionVersionResponse
extends PersonalizeResponse
implements ToCopyableBuilder<Builder, DescribeSolutionVersionResponse> {
    private static final SdkField<SolutionVersion> SOLUTION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("solutionVersion").getter(DescribeSolutionVersionResponse.getter(DescribeSolutionVersionResponse::solutionVersion)).setter(DescribeSolutionVersionResponse.setter(Builder::solutionVersion)).constructor(SolutionVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOLUTION_VERSION_FIELD));
    private final SolutionVersion solutionVersion;

    private DescribeSolutionVersionResponse(BuilderImpl builder) {
        super(builder);
        this.solutionVersion = builder.solutionVersion;
    }

    public final SolutionVersion solutionVersion() {
        return this.solutionVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.solutionVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSolutionVersionResponse)) {
            return false;
        }
        DescribeSolutionVersionResponse other = (DescribeSolutionVersionResponse)((Object)obj);
        return Objects.equals(this.solutionVersion(), other.solutionVersion());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSolutionVersionResponse").add("SolutionVersion", (Object)this.solutionVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "solutionVersion": {
                return Optional.ofNullable(clazz.cast(this.solutionVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSolutionVersionResponse, T> g) {
        return obj -> g.apply((DescribeSolutionVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PersonalizeResponse.BuilderImpl
    implements Builder {
        private SolutionVersion solutionVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSolutionVersionResponse model) {
            super(model);
            this.solutionVersion(model.solutionVersion);
        }

        public final SolutionVersion.Builder getSolutionVersion() {
            return this.solutionVersion != null ? this.solutionVersion.toBuilder() : null;
        }

        @Override
        public final Builder solutionVersion(SolutionVersion solutionVersion) {
            this.solutionVersion = solutionVersion;
            return this;
        }

        public final void setSolutionVersion(SolutionVersion.BuilderImpl solutionVersion) {
            this.solutionVersion = solutionVersion != null ? solutionVersion.build() : null;
        }

        @Override
        public DescribeSolutionVersionResponse build() {
            return new DescribeSolutionVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PersonalizeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSolutionVersionResponse> {
        public Builder solutionVersion(SolutionVersion var1);

        default public Builder solutionVersion(Consumer<SolutionVersion.Builder> solutionVersion) {
            return this.solutionVersion((SolutionVersion)((SolutionVersion.Builder)SolutionVersion.builder().applyMutation(solutionVersion)).build());
        }
    }
}

