/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatasetGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatasetGroup> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(DatasetGroup.getter(DatasetGroup::name)).setter(DatasetGroup.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DATASET_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetGroupArn").getter(DatasetGroup.getter(DatasetGroup::datasetGroupArn)).setter(DatasetGroup.setter(Builder::datasetGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetGroupArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DatasetGroup.getter(DatasetGroup::status)).setter(DatasetGroup.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(DatasetGroup.getter(DatasetGroup::roleArn)).setter(DatasetGroup.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyArn").getter(DatasetGroup.getter(DatasetGroup::kmsKeyArn)).setter(DatasetGroup.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(DatasetGroup.getter(DatasetGroup::creationDateTime)).setter(DatasetGroup.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDateTime").getter(DatasetGroup.getter(DatasetGroup::lastUpdatedDateTime)).setter(DatasetGroup.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureReason").getter(DatasetGroup.getter(DatasetGroup::failureReason)).setter(DatasetGroup.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DATASET_GROUP_ARN_FIELD, STATUS_FIELD, ROLE_ARN_FIELD, KMS_KEY_ARN_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD, FAILURE_REASON_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String datasetGroupArn;
    private final String status;
    private final String roleArn;
    private final String kmsKeyArn;
    private final Instant creationDateTime;
    private final Instant lastUpdatedDateTime;
    private final String failureReason;

    private DatasetGroup(BuilderImpl builder) {
        this.name = builder.name;
        this.datasetGroupArn = builder.datasetGroupArn;
        this.status = builder.status;
        this.roleArn = builder.roleArn;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.failureReason = builder.failureReason;
    }

    public String name() {
        return this.name;
    }

    public String datasetGroupArn() {
        return this.datasetGroupArn;
    }

    public String status() {
        return this.status;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public Instant creationDateTime() {
        return this.creationDateTime;
    }

    public Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetGroup)) {
            return false;
        }
        DatasetGroup other = (DatasetGroup)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.datasetGroupArn(), other.datasetGroupArn()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime()) && Objects.equals(this.failureReason(), other.failureReason());
    }

    public String toString() {
        return ToString.builder((String)"DatasetGroup").add("Name", (Object)this.name()).add("DatasetGroupArn", (Object)this.datasetGroupArn()).add("Status", (Object)this.status()).add("RoleArn", (Object)this.roleArn()).add("KmsKeyArn", (Object)this.kmsKeyArn()).add("CreationDateTime", (Object)this.creationDateTime()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).add("FailureReason", (Object)this.failureReason()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "datasetGroupArn": {
                return Optional.ofNullable(clazz.cast(this.datasetGroupArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "kmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "lastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatasetGroup, T> g) {
        return obj -> g.apply((DatasetGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String datasetGroupArn;
        private String status;
        private String roleArn;
        private String kmsKeyArn;
        private Instant creationDateTime;
        private Instant lastUpdatedDateTime;
        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetGroup model) {
            this.name(model.name);
            this.datasetGroupArn(model.datasetGroupArn);
            this.status(model.status);
            this.roleArn(model.roleArn);
            this.kmsKeyArn(model.kmsKeyArn);
            this.creationDateTime(model.creationDateTime);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
            this.failureReason(model.failureReason);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDatasetGroupArn() {
            return this.datasetGroupArn;
        }

        @Override
        public final Builder datasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
            return this;
        }

        public final void setDatasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public DatasetGroup build() {
            return new DatasetGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatasetGroup> {
        public Builder name(String var1);

        public Builder datasetGroupArn(String var1);

        public Builder status(String var1);

        public Builder roleArn(String var1);

        public Builder kmsKeyArn(String var1);

        public Builder creationDateTime(Instant var1);

        public Builder lastUpdatedDateTime(Instant var1);

        public Builder failureReason(String var1);
    }
}

