/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.personalize.model.HyperParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchInferenceJobConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchInferenceJobConfig> {
    private static final SdkField<Map<String, String>> ITEM_EXPLORATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(BatchInferenceJobConfig.getter(BatchInferenceJobConfig::itemExplorationConfig)).setter(BatchInferenceJobConfig.setter(Builder::itemExplorationConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemExplorationConfig").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_EXPLORATION_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, String> itemExplorationConfig;

    private BatchInferenceJobConfig(BuilderImpl builder) {
        this.itemExplorationConfig = builder.itemExplorationConfig;
    }

    public boolean hasItemExplorationConfig() {
        return this.itemExplorationConfig != null && !(this.itemExplorationConfig instanceof SdkAutoConstructMap);
    }

    public Map<String, String> itemExplorationConfig() {
        return this.itemExplorationConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.itemExplorationConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchInferenceJobConfig)) {
            return false;
        }
        BatchInferenceJobConfig other = (BatchInferenceJobConfig)obj;
        return Objects.equals(this.itemExplorationConfig(), other.itemExplorationConfig());
    }

    public String toString() {
        return ToString.builder((String)"BatchInferenceJobConfig").add("ItemExplorationConfig", this.itemExplorationConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "itemExplorationConfig": {
                return Optional.ofNullable(clazz.cast(this.itemExplorationConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchInferenceJobConfig, T> g) {
        return obj -> g.apply((BatchInferenceJobConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> itemExplorationConfig = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchInferenceJobConfig model) {
            this.itemExplorationConfig(model.itemExplorationConfig);
        }

        public final Map<String, String> getItemExplorationConfig() {
            return this.itemExplorationConfig;
        }

        @Override
        public final Builder itemExplorationConfig(Map<String, String> itemExplorationConfig) {
            this.itemExplorationConfig = HyperParametersCopier.copy(itemExplorationConfig);
            return this;
        }

        public final void setItemExplorationConfig(Map<String, String> itemExplorationConfig) {
            this.itemExplorationConfig = HyperParametersCopier.copy(itemExplorationConfig);
        }

        public BatchInferenceJobConfig build() {
            return new BatchInferenceJobConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchInferenceJobConfig> {
        public Builder itemExplorationConfig(Map<String, String> var1);
    }
}

