/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.personalize.model.S3DataConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchInferenceJobInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchInferenceJobInput> {
    private static final SdkField<S3DataConfig> S3_DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(BatchInferenceJobInput.getter(BatchInferenceJobInput::s3DataSource)).setter(BatchInferenceJobInput.setter(Builder::s3DataSource)).constructor(S3DataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3DataSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_DATA_SOURCE_FIELD));
    private static final long serialVersionUID = 1L;
    private final S3DataConfig s3DataSource;

    private BatchInferenceJobInput(BuilderImpl builder) {
        this.s3DataSource = builder.s3DataSource;
    }

    public S3DataConfig s3DataSource() {
        return this.s3DataSource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3DataSource());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchInferenceJobInput)) {
            return false;
        }
        BatchInferenceJobInput other = (BatchInferenceJobInput)obj;
        return Objects.equals(this.s3DataSource(), other.s3DataSource());
    }

    public String toString() {
        return ToString.builder((String)"BatchInferenceJobInput").add("S3DataSource", (Object)this.s3DataSource()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "s3DataSource": {
                return Optional.ofNullable(clazz.cast(this.s3DataSource()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchInferenceJobInput, T> g) {
        return obj -> g.apply((BatchInferenceJobInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private S3DataConfig s3DataSource;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchInferenceJobInput model) {
            this.s3DataSource(model.s3DataSource);
        }

        public final S3DataConfig.Builder getS3DataSource() {
            return this.s3DataSource != null ? this.s3DataSource.toBuilder() : null;
        }

        @Override
        public final Builder s3DataSource(S3DataConfig s3DataSource) {
            this.s3DataSource = s3DataSource;
            return this;
        }

        public final void setS3DataSource(S3DataConfig.BuilderImpl s3DataSource) {
            this.s3DataSource = s3DataSource != null ? s3DataSource.build() : null;
        }

        public BatchInferenceJobInput build() {
            return new BatchInferenceJobInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchInferenceJobInput> {
        public Builder s3DataSource(S3DataConfig var1);

        default public Builder s3DataSource(Consumer<S3DataConfig.Builder> s3DataSource) {
            return this.s3DataSource((S3DataConfig)((S3DataConfig.Builder)S3DataConfig.builder().applyMutation(s3DataSource)).build());
        }
    }
}

