/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.personalize.PersonalizeClient;
import software.amazon.awssdk.services.personalize.model.CreateBatchInferenceJobRequest;
import software.amazon.awssdk.services.personalize.model.CreateBatchInferenceJobResponse;
import software.amazon.awssdk.services.personalize.model.CreateCampaignRequest;
import software.amazon.awssdk.services.personalize.model.CreateCampaignResponse;
import software.amazon.awssdk.services.personalize.model.CreateDatasetGroupRequest;
import software.amazon.awssdk.services.personalize.model.CreateDatasetGroupResponse;
import software.amazon.awssdk.services.personalize.model.CreateDatasetImportJobRequest;
import software.amazon.awssdk.services.personalize.model.CreateDatasetImportJobResponse;
import software.amazon.awssdk.services.personalize.model.CreateDatasetRequest;
import software.amazon.awssdk.services.personalize.model.CreateDatasetResponse;
import software.amazon.awssdk.services.personalize.model.CreateEventTrackerRequest;
import software.amazon.awssdk.services.personalize.model.CreateEventTrackerResponse;
import software.amazon.awssdk.services.personalize.model.CreateFilterRequest;
import software.amazon.awssdk.services.personalize.model.CreateFilterResponse;
import software.amazon.awssdk.services.personalize.model.CreateSchemaRequest;
import software.amazon.awssdk.services.personalize.model.CreateSchemaResponse;
import software.amazon.awssdk.services.personalize.model.CreateSolutionRequest;
import software.amazon.awssdk.services.personalize.model.CreateSolutionResponse;
import software.amazon.awssdk.services.personalize.model.CreateSolutionVersionRequest;
import software.amazon.awssdk.services.personalize.model.CreateSolutionVersionResponse;
import software.amazon.awssdk.services.personalize.model.DeleteCampaignRequest;
import software.amazon.awssdk.services.personalize.model.DeleteCampaignResponse;
import software.amazon.awssdk.services.personalize.model.DeleteDatasetGroupRequest;
import software.amazon.awssdk.services.personalize.model.DeleteDatasetGroupResponse;
import software.amazon.awssdk.services.personalize.model.DeleteDatasetRequest;
import software.amazon.awssdk.services.personalize.model.DeleteDatasetResponse;
import software.amazon.awssdk.services.personalize.model.DeleteEventTrackerRequest;
import software.amazon.awssdk.services.personalize.model.DeleteEventTrackerResponse;
import software.amazon.awssdk.services.personalize.model.DeleteFilterRequest;
import software.amazon.awssdk.services.personalize.model.DeleteFilterResponse;
import software.amazon.awssdk.services.personalize.model.DeleteSchemaRequest;
import software.amazon.awssdk.services.personalize.model.DeleteSchemaResponse;
import software.amazon.awssdk.services.personalize.model.DeleteSolutionRequest;
import software.amazon.awssdk.services.personalize.model.DeleteSolutionResponse;
import software.amazon.awssdk.services.personalize.model.DescribeAlgorithmRequest;
import software.amazon.awssdk.services.personalize.model.DescribeAlgorithmResponse;
import software.amazon.awssdk.services.personalize.model.DescribeBatchInferenceJobRequest;
import software.amazon.awssdk.services.personalize.model.DescribeBatchInferenceJobResponse;
import software.amazon.awssdk.services.personalize.model.DescribeCampaignRequest;
import software.amazon.awssdk.services.personalize.model.DescribeCampaignResponse;
import software.amazon.awssdk.services.personalize.model.DescribeDatasetGroupRequest;
import software.amazon.awssdk.services.personalize.model.DescribeDatasetGroupResponse;
import software.amazon.awssdk.services.personalize.model.DescribeDatasetImportJobRequest;
import software.amazon.awssdk.services.personalize.model.DescribeDatasetImportJobResponse;
import software.amazon.awssdk.services.personalize.model.DescribeDatasetRequest;
import software.amazon.awssdk.services.personalize.model.DescribeDatasetResponse;
import software.amazon.awssdk.services.personalize.model.DescribeEventTrackerRequest;
import software.amazon.awssdk.services.personalize.model.DescribeEventTrackerResponse;
import software.amazon.awssdk.services.personalize.model.DescribeFeatureTransformationRequest;
import software.amazon.awssdk.services.personalize.model.DescribeFeatureTransformationResponse;
import software.amazon.awssdk.services.personalize.model.DescribeFilterRequest;
import software.amazon.awssdk.services.personalize.model.DescribeFilterResponse;
import software.amazon.awssdk.services.personalize.model.DescribeRecipeRequest;
import software.amazon.awssdk.services.personalize.model.DescribeRecipeResponse;
import software.amazon.awssdk.services.personalize.model.DescribeSchemaRequest;
import software.amazon.awssdk.services.personalize.model.DescribeSchemaResponse;
import software.amazon.awssdk.services.personalize.model.DescribeSolutionRequest;
import software.amazon.awssdk.services.personalize.model.DescribeSolutionResponse;
import software.amazon.awssdk.services.personalize.model.DescribeSolutionVersionRequest;
import software.amazon.awssdk.services.personalize.model.DescribeSolutionVersionResponse;
import software.amazon.awssdk.services.personalize.model.GetSolutionMetricsRequest;
import software.amazon.awssdk.services.personalize.model.GetSolutionMetricsResponse;
import software.amazon.awssdk.services.personalize.model.InvalidInputException;
import software.amazon.awssdk.services.personalize.model.InvalidNextTokenException;
import software.amazon.awssdk.services.personalize.model.LimitExceededException;
import software.amazon.awssdk.services.personalize.model.ListBatchInferenceJobsRequest;
import software.amazon.awssdk.services.personalize.model.ListBatchInferenceJobsResponse;
import software.amazon.awssdk.services.personalize.model.ListCampaignsRequest;
import software.amazon.awssdk.services.personalize.model.ListCampaignsResponse;
import software.amazon.awssdk.services.personalize.model.ListDatasetGroupsRequest;
import software.amazon.awssdk.services.personalize.model.ListDatasetGroupsResponse;
import software.amazon.awssdk.services.personalize.model.ListDatasetImportJobsRequest;
import software.amazon.awssdk.services.personalize.model.ListDatasetImportJobsResponse;
import software.amazon.awssdk.services.personalize.model.ListDatasetsRequest;
import software.amazon.awssdk.services.personalize.model.ListDatasetsResponse;
import software.amazon.awssdk.services.personalize.model.ListEventTrackersRequest;
import software.amazon.awssdk.services.personalize.model.ListEventTrackersResponse;
import software.amazon.awssdk.services.personalize.model.ListFiltersRequest;
import software.amazon.awssdk.services.personalize.model.ListFiltersResponse;
import software.amazon.awssdk.services.personalize.model.ListRecipesRequest;
import software.amazon.awssdk.services.personalize.model.ListRecipesResponse;
import software.amazon.awssdk.services.personalize.model.ListSchemasRequest;
import software.amazon.awssdk.services.personalize.model.ListSchemasResponse;
import software.amazon.awssdk.services.personalize.model.ListSolutionVersionsRequest;
import software.amazon.awssdk.services.personalize.model.ListSolutionVersionsResponse;
import software.amazon.awssdk.services.personalize.model.ListSolutionsRequest;
import software.amazon.awssdk.services.personalize.model.ListSolutionsResponse;
import software.amazon.awssdk.services.personalize.model.PersonalizeException;
import software.amazon.awssdk.services.personalize.model.PersonalizeRequest;
import software.amazon.awssdk.services.personalize.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.personalize.model.ResourceInUseException;
import software.amazon.awssdk.services.personalize.model.ResourceNotFoundException;
import software.amazon.awssdk.services.personalize.model.UpdateCampaignRequest;
import software.amazon.awssdk.services.personalize.model.UpdateCampaignResponse;
import software.amazon.awssdk.services.personalize.paginators.ListBatchInferenceJobsIterable;
import software.amazon.awssdk.services.personalize.paginators.ListCampaignsIterable;
import software.amazon.awssdk.services.personalize.paginators.ListDatasetGroupsIterable;
import software.amazon.awssdk.services.personalize.paginators.ListDatasetImportJobsIterable;
import software.amazon.awssdk.services.personalize.paginators.ListDatasetsIterable;
import software.amazon.awssdk.services.personalize.paginators.ListEventTrackersIterable;
import software.amazon.awssdk.services.personalize.paginators.ListRecipesIterable;
import software.amazon.awssdk.services.personalize.paginators.ListSchemasIterable;
import software.amazon.awssdk.services.personalize.paginators.ListSolutionVersionsIterable;
import software.amazon.awssdk.services.personalize.paginators.ListSolutionsIterable;
import software.amazon.awssdk.services.personalize.transform.CreateBatchInferenceJobRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.CreateCampaignRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.CreateDatasetGroupRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.CreateDatasetImportJobRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.CreateDatasetRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.CreateEventTrackerRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.CreateFilterRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.CreateSchemaRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.CreateSolutionRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.CreateSolutionVersionRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DeleteCampaignRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DeleteDatasetGroupRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DeleteDatasetRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DeleteEventTrackerRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DeleteFilterRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DeleteSchemaRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DeleteSolutionRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeAlgorithmRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeBatchInferenceJobRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeCampaignRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeDatasetGroupRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeDatasetImportJobRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeDatasetRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeEventTrackerRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeFeatureTransformationRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeFilterRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeRecipeRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeSchemaRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeSolutionRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeSolutionVersionRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.GetSolutionMetricsRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListBatchInferenceJobsRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListCampaignsRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListDatasetGroupsRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListDatasetImportJobsRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListDatasetsRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListEventTrackersRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListFiltersRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListRecipesRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListSchemasRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListSolutionVersionsRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListSolutionsRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.UpdateCampaignRequestMarshaller;

@SdkInternalApi
final class DefaultPersonalizeClient
implements PersonalizeClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultPersonalizeClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "personalize";
    }

    @Override
    public CreateBatchInferenceJobResponse createBatchInferenceJob(CreateBatchInferenceJobRequest createBatchInferenceJobRequest) throws InvalidInputException, ResourceAlreadyExistsException, LimitExceededException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBatchInferenceJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateBatchInferenceJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBatchInferenceJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createBatchInferenceJobRequest).withMarshaller((Marshaller)new CreateBatchInferenceJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateCampaignResponse createCampaign(CreateCampaignRequest createCampaignRequest) throws InvalidInputException, ResourceNotFoundException, ResourceAlreadyExistsException, LimitExceededException, ResourceInUseException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCampaignResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateCampaignResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCampaign").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createCampaignRequest).withMarshaller((Marshaller)new CreateCampaignRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateDatasetResponse createDataset(CreateDatasetRequest createDatasetRequest) throws InvalidInputException, ResourceNotFoundException, ResourceAlreadyExistsException, LimitExceededException, ResourceInUseException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDatasetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateDatasetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDataset").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDatasetRequest).withMarshaller((Marshaller)new CreateDatasetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateDatasetGroupResponse createDatasetGroup(CreateDatasetGroupRequest createDatasetGroupRequest) throws InvalidInputException, ResourceAlreadyExistsException, LimitExceededException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDatasetGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateDatasetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDatasetGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDatasetGroupRequest).withMarshaller((Marshaller)new CreateDatasetGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateDatasetImportJobResponse createDatasetImportJob(CreateDatasetImportJobRequest createDatasetImportJobRequest) throws InvalidInputException, ResourceNotFoundException, ResourceAlreadyExistsException, LimitExceededException, ResourceInUseException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDatasetImportJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateDatasetImportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDatasetImportJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDatasetImportJobRequest).withMarshaller((Marshaller)new CreateDatasetImportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateEventTrackerResponse createEventTracker(CreateEventTrackerRequest createEventTrackerRequest) throws InvalidInputException, ResourceAlreadyExistsException, ResourceNotFoundException, LimitExceededException, ResourceInUseException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateEventTrackerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateEventTrackerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEventTracker").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createEventTrackerRequest).withMarshaller((Marshaller)new CreateEventTrackerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateFilterResponse createFilter(CreateFilterRequest createFilterRequest) throws InvalidInputException, ResourceAlreadyExistsException, ResourceNotFoundException, LimitExceededException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFilterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateFilterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFilter").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createFilterRequest).withMarshaller((Marshaller)new CreateFilterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateSchemaResponse createSchema(CreateSchemaRequest createSchemaRequest) throws InvalidInputException, ResourceAlreadyExistsException, LimitExceededException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSchemaResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateSchemaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSchema").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSchemaRequest).withMarshaller((Marshaller)new CreateSchemaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateSolutionResponse createSolution(CreateSolutionRequest createSolutionRequest) throws InvalidInputException, ResourceAlreadyExistsException, ResourceNotFoundException, LimitExceededException, ResourceInUseException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSolutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateSolutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSolution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSolutionRequest).withMarshaller((Marshaller)new CreateSolutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateSolutionVersionResponse createSolutionVersion(CreateSolutionVersionRequest createSolutionVersionRequest) throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSolutionVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateSolutionVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSolutionVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSolutionVersionRequest).withMarshaller((Marshaller)new CreateSolutionVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteCampaignResponse deleteCampaign(DeleteCampaignRequest deleteCampaignRequest) throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCampaignResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteCampaignResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCampaign").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteCampaignRequest).withMarshaller((Marshaller)new DeleteCampaignRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteDatasetResponse deleteDataset(DeleteDatasetRequest deleteDatasetRequest) throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDatasetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteDatasetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDataset").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDatasetRequest).withMarshaller((Marshaller)new DeleteDatasetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteDatasetGroupResponse deleteDatasetGroup(DeleteDatasetGroupRequest deleteDatasetGroupRequest) throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDatasetGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteDatasetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDatasetGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDatasetGroupRequest).withMarshaller((Marshaller)new DeleteDatasetGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteEventTrackerResponse deleteEventTracker(DeleteEventTrackerRequest deleteEventTrackerRequest) throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEventTrackerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteEventTrackerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEventTracker").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteEventTrackerRequest).withMarshaller((Marshaller)new DeleteEventTrackerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteFilterResponse deleteFilter(DeleteFilterRequest deleteFilterRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFilterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteFilterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFilter").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteFilterRequest).withMarshaller((Marshaller)new DeleteFilterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteSchemaResponse deleteSchema(DeleteSchemaRequest deleteSchemaRequest) throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSchemaResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteSchemaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSchema").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSchemaRequest).withMarshaller((Marshaller)new DeleteSchemaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteSolutionResponse deleteSolution(DeleteSolutionRequest deleteSolutionRequest) throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSolutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteSolutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSolution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSolutionRequest).withMarshaller((Marshaller)new DeleteSolutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeAlgorithmResponse describeAlgorithm(DescribeAlgorithmRequest describeAlgorithmRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAlgorithmResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeAlgorithmResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAlgorithm").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAlgorithmRequest).withMarshaller((Marshaller)new DescribeAlgorithmRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeBatchInferenceJobResponse describeBatchInferenceJob(DescribeBatchInferenceJobRequest describeBatchInferenceJobRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeBatchInferenceJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeBatchInferenceJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeBatchInferenceJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeBatchInferenceJobRequest).withMarshaller((Marshaller)new DescribeBatchInferenceJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeCampaignResponse describeCampaign(DescribeCampaignRequest describeCampaignRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCampaignResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeCampaignResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCampaign").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeCampaignRequest).withMarshaller((Marshaller)new DescribeCampaignRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeDatasetResponse describeDataset(DescribeDatasetRequest describeDatasetRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDatasetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeDatasetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDataset").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDatasetRequest).withMarshaller((Marshaller)new DescribeDatasetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeDatasetGroupResponse describeDatasetGroup(DescribeDatasetGroupRequest describeDatasetGroupRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDatasetGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeDatasetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDatasetGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDatasetGroupRequest).withMarshaller((Marshaller)new DescribeDatasetGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeDatasetImportJobResponse describeDatasetImportJob(DescribeDatasetImportJobRequest describeDatasetImportJobRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDatasetImportJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeDatasetImportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDatasetImportJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDatasetImportJobRequest).withMarshaller((Marshaller)new DescribeDatasetImportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeEventTrackerResponse describeEventTracker(DescribeEventTrackerRequest describeEventTrackerRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEventTrackerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeEventTrackerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEventTracker").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventTrackerRequest).withMarshaller((Marshaller)new DescribeEventTrackerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeFeatureTransformationResponse describeFeatureTransformation(DescribeFeatureTransformationRequest describeFeatureTransformationRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFeatureTransformationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeFeatureTransformationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFeatureTransformation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeFeatureTransformationRequest).withMarshaller((Marshaller)new DescribeFeatureTransformationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeFilterResponse describeFilter(DescribeFilterRequest describeFilterRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFilterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeFilterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFilter").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeFilterRequest).withMarshaller((Marshaller)new DescribeFilterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeRecipeResponse describeRecipe(DescribeRecipeRequest describeRecipeRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRecipeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeRecipeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRecipe").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeRecipeRequest).withMarshaller((Marshaller)new DescribeRecipeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeSchemaResponse describeSchema(DescribeSchemaRequest describeSchemaRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSchemaResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeSchemaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSchema").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeSchemaRequest).withMarshaller((Marshaller)new DescribeSchemaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeSolutionResponse describeSolution(DescribeSolutionRequest describeSolutionRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSolutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeSolutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSolution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeSolutionRequest).withMarshaller((Marshaller)new DescribeSolutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeSolutionVersionResponse describeSolutionVersion(DescribeSolutionVersionRequest describeSolutionVersionRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSolutionVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeSolutionVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSolutionVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeSolutionVersionRequest).withMarshaller((Marshaller)new DescribeSolutionVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetSolutionMetricsResponse getSolutionMetrics(GetSolutionMetricsRequest getSolutionMetricsRequest) throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSolutionMetricsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetSolutionMetricsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSolutionMetrics").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSolutionMetricsRequest).withMarshaller((Marshaller)new GetSolutionMetricsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListBatchInferenceJobsResponse listBatchInferenceJobs(ListBatchInferenceJobsRequest listBatchInferenceJobsRequest) throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBatchInferenceJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListBatchInferenceJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBatchInferenceJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listBatchInferenceJobsRequest).withMarshaller((Marshaller)new ListBatchInferenceJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListBatchInferenceJobsIterable listBatchInferenceJobsPaginator(ListBatchInferenceJobsRequest listBatchInferenceJobsRequest) throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        return new ListBatchInferenceJobsIterable(this, this.applyPaginatorUserAgent(listBatchInferenceJobsRequest));
    }

    @Override
    public ListCampaignsResponse listCampaigns(ListCampaignsRequest listCampaignsRequest) throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCampaignsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListCampaignsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCampaigns").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listCampaignsRequest).withMarshaller((Marshaller)new ListCampaignsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListCampaignsIterable listCampaignsPaginator(ListCampaignsRequest listCampaignsRequest) throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        return new ListCampaignsIterable(this, this.applyPaginatorUserAgent(listCampaignsRequest));
    }

    @Override
    public ListDatasetGroupsResponse listDatasetGroups(ListDatasetGroupsRequest listDatasetGroupsRequest) throws InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDatasetGroupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListDatasetGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDatasetGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDatasetGroupsRequest).withMarshaller((Marshaller)new ListDatasetGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListDatasetGroupsIterable listDatasetGroupsPaginator(ListDatasetGroupsRequest listDatasetGroupsRequest) throws InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        return new ListDatasetGroupsIterable(this, this.applyPaginatorUserAgent(listDatasetGroupsRequest));
    }

    @Override
    public ListDatasetImportJobsResponse listDatasetImportJobs(ListDatasetImportJobsRequest listDatasetImportJobsRequest) throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDatasetImportJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListDatasetImportJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDatasetImportJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDatasetImportJobsRequest).withMarshaller((Marshaller)new ListDatasetImportJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListDatasetImportJobsIterable listDatasetImportJobsPaginator(ListDatasetImportJobsRequest listDatasetImportJobsRequest) throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        return new ListDatasetImportJobsIterable(this, this.applyPaginatorUserAgent(listDatasetImportJobsRequest));
    }

    @Override
    public ListDatasetsResponse listDatasets(ListDatasetsRequest listDatasetsRequest) throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDatasetsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListDatasetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDatasets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDatasetsRequest).withMarshaller((Marshaller)new ListDatasetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListDatasetsIterable listDatasetsPaginator(ListDatasetsRequest listDatasetsRequest) throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        return new ListDatasetsIterable(this, this.applyPaginatorUserAgent(listDatasetsRequest));
    }

    @Override
    public ListEventTrackersResponse listEventTrackers(ListEventTrackersRequest listEventTrackersRequest) throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEventTrackersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListEventTrackersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEventTrackers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listEventTrackersRequest).withMarshaller((Marshaller)new ListEventTrackersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListEventTrackersIterable listEventTrackersPaginator(ListEventTrackersRequest listEventTrackersRequest) throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        return new ListEventTrackersIterable(this, this.applyPaginatorUserAgent(listEventTrackersRequest));
    }

    @Override
    public ListFiltersResponse listFilters(ListFiltersRequest listFiltersRequest) throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFiltersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListFiltersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFilters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listFiltersRequest).withMarshaller((Marshaller)new ListFiltersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListRecipesResponse listRecipes(ListRecipesRequest listRecipesRequest) throws InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRecipesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListRecipesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRecipes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRecipesRequest).withMarshaller((Marshaller)new ListRecipesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListRecipesIterable listRecipesPaginator(ListRecipesRequest listRecipesRequest) throws InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        return new ListRecipesIterable(this, this.applyPaginatorUserAgent(listRecipesRequest));
    }

    @Override
    public ListSchemasResponse listSchemas(ListSchemasRequest listSchemasRequest) throws InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSchemasResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListSchemasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSchemas").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSchemasRequest).withMarshaller((Marshaller)new ListSchemasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListSchemasIterable listSchemasPaginator(ListSchemasRequest listSchemasRequest) throws InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        return new ListSchemasIterable(this, this.applyPaginatorUserAgent(listSchemasRequest));
    }

    @Override
    public ListSolutionVersionsResponse listSolutionVersions(ListSolutionVersionsRequest listSolutionVersionsRequest) throws InvalidInputException, ResourceNotFoundException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSolutionVersionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListSolutionVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSolutionVersions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSolutionVersionsRequest).withMarshaller((Marshaller)new ListSolutionVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListSolutionVersionsIterable listSolutionVersionsPaginator(ListSolutionVersionsRequest listSolutionVersionsRequest) throws InvalidInputException, ResourceNotFoundException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        return new ListSolutionVersionsIterable(this, this.applyPaginatorUserAgent(listSolutionVersionsRequest));
    }

    @Override
    public ListSolutionsResponse listSolutions(ListSolutionsRequest listSolutionsRequest) throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSolutionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListSolutionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSolutions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSolutionsRequest).withMarshaller((Marshaller)new ListSolutionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListSolutionsIterable listSolutionsPaginator(ListSolutionsRequest listSolutionsRequest) throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        return new ListSolutionsIterable(this, this.applyPaginatorUserAgent(listSolutionsRequest));
    }

    @Override
    public UpdateCampaignResponse updateCampaign(UpdateCampaignRequest updateCampaignRequest) throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateCampaignResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateCampaignResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCampaign").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateCampaignRequest).withMarshaller((Marshaller)new UpdateCampaignRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(PersonalizeException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ResourceInUseException").exceptionBuilderSupplier(ResourceInUseException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").exceptionBuilderSupplier(InvalidNextTokenException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidInputException").exceptionBuilderSupplier(InvalidInputException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends PersonalizeRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.13.32").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((PersonalizeRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

