/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBatchInferenceJobRequest extends PersonalizeRequest implements
        ToCopyableBuilder<CreateBatchInferenceJobRequest.Builder, CreateBatchInferenceJobRequest> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateBatchInferenceJobRequest::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()).build();

    private static final SdkField<String> SOLUTION_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateBatchInferenceJobRequest::solutionVersionArn)).setter(setter(Builder::solutionVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionVersionArn").build())
            .build();

    private static final SdkField<Integer> NUM_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateBatchInferenceJobRequest::numResults)).setter(setter(Builder::numResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numResults").build()).build();

    private static final SdkField<BatchInferenceJobInput> JOB_INPUT_FIELD = SdkField
            .<BatchInferenceJobInput> builder(MarshallingType.SDK_POJO).getter(getter(CreateBatchInferenceJobRequest::jobInput))
            .setter(setter(Builder::jobInput)).constructor(BatchInferenceJobInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobInput").build()).build();

    private static final SdkField<BatchInferenceJobOutput> JOB_OUTPUT_FIELD = SdkField
            .<BatchInferenceJobOutput> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateBatchInferenceJobRequest::jobOutput)).setter(setter(Builder::jobOutput))
            .constructor(BatchInferenceJobOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobOutput").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateBatchInferenceJobRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD,
            SOLUTION_VERSION_ARN_FIELD, NUM_RESULTS_FIELD, JOB_INPUT_FIELD, JOB_OUTPUT_FIELD, ROLE_ARN_FIELD));

    private final String jobName;

    private final String solutionVersionArn;

    private final Integer numResults;

    private final BatchInferenceJobInput jobInput;

    private final BatchInferenceJobOutput jobOutput;

    private final String roleArn;

    private CreateBatchInferenceJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.solutionVersionArn = builder.solutionVersionArn;
        this.numResults = builder.numResults;
        this.jobInput = builder.jobInput;
        this.jobOutput = builder.jobOutput;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The name of the batch inference job to create.
     * </p>
     * 
     * @return The name of the batch inference job to create.
     */
    public String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the solution version that will be used to generate the batch inference
     * recommendations.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the solution version that will be used to generate the batch inference
     *         recommendations.
     */
    public String solutionVersionArn() {
        return solutionVersionArn;
    }

    /**
     * <p>
     * The number of recommendations to retreive.
     * </p>
     * 
     * @return The number of recommendations to retreive.
     */
    public Integer numResults() {
        return numResults;
    }

    /**
     * <p>
     * The Amazon S3 path that leads to the input file to base your recommendations on. The input material must be in
     * JSON format.
     * </p>
     * 
     * @return The Amazon S3 path that leads to the input file to base your recommendations on. The input material must
     *         be in JSON format.
     */
    public BatchInferenceJobInput jobInput() {
        return jobInput;
    }

    /**
     * <p>
     * The path to the Amazon S3 bucket where the job's output will be stored.
     * </p>
     * 
     * @return The path to the Amazon S3 bucket where the job's output will be stored.
     */
    public BatchInferenceJobOutput jobOutput() {
        return jobOutput;
    }

    /**
     * <p>
     * The ARN of the Amazon Identity and Access Management role that has permissions to read and write to your input
     * and out Amazon S3 buckets respectively.
     * </p>
     * 
     * @return The ARN of the Amazon Identity and Access Management role that has permissions to read and write to your
     *         input and out Amazon S3 buckets respectively.
     */
    public String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(solutionVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(numResults());
        hashCode = 31 * hashCode + Objects.hashCode(jobInput());
        hashCode = 31 * hashCode + Objects.hashCode(jobOutput());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBatchInferenceJobRequest)) {
            return false;
        }
        CreateBatchInferenceJobRequest other = (CreateBatchInferenceJobRequest) obj;
        return Objects.equals(jobName(), other.jobName()) && Objects.equals(solutionVersionArn(), other.solutionVersionArn())
                && Objects.equals(numResults(), other.numResults()) && Objects.equals(jobInput(), other.jobInput())
                && Objects.equals(jobOutput(), other.jobOutput()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateBatchInferenceJobRequest").add("JobName", jobName())
                .add("SolutionVersionArn", solutionVersionArn()).add("NumResults", numResults()).add("JobInput", jobInput())
                .add("JobOutput", jobOutput()).add("RoleArn", roleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "solutionVersionArn":
            return Optional.ofNullable(clazz.cast(solutionVersionArn()));
        case "numResults":
            return Optional.ofNullable(clazz.cast(numResults()));
        case "jobInput":
            return Optional.ofNullable(clazz.cast(jobInput()));
        case "jobOutput":
            return Optional.ofNullable(clazz.cast(jobOutput()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBatchInferenceJobRequest, T> g) {
        return obj -> g.apply((CreateBatchInferenceJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateBatchInferenceJobRequest> {
        /**
         * <p>
         * The name of the batch inference job to create.
         * </p>
         * 
         * @param jobName
         *        The name of the batch inference job to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the solution version that will be used to generate the batch inference
         * recommendations.
         * </p>
         * 
         * @param solutionVersionArn
         *        The Amazon Resource Name (ARN) of the solution version that will be used to generate the batch
         *        inference recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutionVersionArn(String solutionVersionArn);

        /**
         * <p>
         * The number of recommendations to retreive.
         * </p>
         * 
         * @param numResults
         *        The number of recommendations to retreive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numResults(Integer numResults);

        /**
         * <p>
         * The Amazon S3 path that leads to the input file to base your recommendations on. The input material must be
         * in JSON format.
         * </p>
         * 
         * @param jobInput
         *        The Amazon S3 path that leads to the input file to base your recommendations on. The input material
         *        must be in JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobInput(BatchInferenceJobInput jobInput);

        /**
         * <p>
         * The Amazon S3 path that leads to the input file to base your recommendations on. The input material must be
         * in JSON format.
         * </p>
         * This is a convenience that creates an instance of the {@link BatchInferenceJobInput.Builder} avoiding the
         * need to create one manually via {@link BatchInferenceJobInput#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchInferenceJobInput.Builder#build()} is called immediately and
         * its result is passed to {@link #jobInput(BatchInferenceJobInput)}.
         * 
         * @param jobInput
         *        a consumer that will call methods on {@link BatchInferenceJobInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobInput(BatchInferenceJobInput)
         */
        default Builder jobInput(Consumer<BatchInferenceJobInput.Builder> jobInput) {
            return jobInput(BatchInferenceJobInput.builder().applyMutation(jobInput).build());
        }

        /**
         * <p>
         * The path to the Amazon S3 bucket where the job's output will be stored.
         * </p>
         * 
         * @param jobOutput
         *        The path to the Amazon S3 bucket where the job's output will be stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobOutput(BatchInferenceJobOutput jobOutput);

        /**
         * <p>
         * The path to the Amazon S3 bucket where the job's output will be stored.
         * </p>
         * This is a convenience that creates an instance of the {@link BatchInferenceJobOutput.Builder} avoiding the
         * need to create one manually via {@link BatchInferenceJobOutput#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchInferenceJobOutput.Builder#build()} is called immediately
         * and its result is passed to {@link #jobOutput(BatchInferenceJobOutput)}.
         * 
         * @param jobOutput
         *        a consumer that will call methods on {@link BatchInferenceJobOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobOutput(BatchInferenceJobOutput)
         */
        default Builder jobOutput(Consumer<BatchInferenceJobOutput.Builder> jobOutput) {
            return jobOutput(BatchInferenceJobOutput.builder().applyMutation(jobOutput).build());
        }

        /**
         * <p>
         * The ARN of the Amazon Identity and Access Management role that has permissions to read and write to your
         * input and out Amazon S3 buckets respectively.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the Amazon Identity and Access Management role that has permissions to read and write to
         *        your input and out Amazon S3 buckets respectively.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PersonalizeRequest.BuilderImpl implements Builder {
        private String jobName;

        private String solutionVersionArn;

        private Integer numResults;

        private BatchInferenceJobInput jobInput;

        private BatchInferenceJobOutput jobOutput;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBatchInferenceJobRequest model) {
            super(model);
            jobName(model.jobName);
            solutionVersionArn(model.solutionVersionArn);
            numResults(model.numResults);
            jobInput(model.jobInput);
            jobOutput(model.jobOutput);
            roleArn(model.roleArn);
        }

        public final String getJobName() {
            return jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final String getSolutionVersionArn() {
            return solutionVersionArn;
        }

        @Override
        public final Builder solutionVersionArn(String solutionVersionArn) {
            this.solutionVersionArn = solutionVersionArn;
            return this;
        }

        public final void setSolutionVersionArn(String solutionVersionArn) {
            this.solutionVersionArn = solutionVersionArn;
        }

        public final Integer getNumResults() {
            return numResults;
        }

        @Override
        public final Builder numResults(Integer numResults) {
            this.numResults = numResults;
            return this;
        }

        public final void setNumResults(Integer numResults) {
            this.numResults = numResults;
        }

        public final BatchInferenceJobInput.Builder getJobInput() {
            return jobInput != null ? jobInput.toBuilder() : null;
        }

        @Override
        public final Builder jobInput(BatchInferenceJobInput jobInput) {
            this.jobInput = jobInput;
            return this;
        }

        public final void setJobInput(BatchInferenceJobInput.BuilderImpl jobInput) {
            this.jobInput = jobInput != null ? jobInput.build() : null;
        }

        public final BatchInferenceJobOutput.Builder getJobOutput() {
            return jobOutput != null ? jobOutput.toBuilder() : null;
        }

        @Override
        public final Builder jobOutput(BatchInferenceJobOutput jobOutput) {
            this.jobOutput = jobOutput;
            return this;
        }

        public final void setJobOutput(BatchInferenceJobOutput.BuilderImpl jobOutput) {
            this.jobOutput = jobOutput != null ? jobOutput.build() : null;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBatchInferenceJobRequest build() {
            return new CreateBatchInferenceJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
