/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pcs.model.SlurmCustomSetting;
import software.amazon.awssdk.services.pcs.model.SlurmCustomSettingsCopier;
import software.amazon.awssdk.services.pcs.model.UpdateAccountingRequest;
import software.amazon.awssdk.services.pcs.model.UpdateSlurmRestRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateClusterSlurmConfigurationRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateClusterSlurmConfigurationRequest> {
    private static final SdkField<Integer> SCALE_DOWN_IDLE_TIME_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("scaleDownIdleTimeInSeconds").getter(UpdateClusterSlurmConfigurationRequest.getter(UpdateClusterSlurmConfigurationRequest::scaleDownIdleTimeInSeconds)).setter(UpdateClusterSlurmConfigurationRequest.setter(Builder::scaleDownIdleTimeInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scaleDownIdleTimeInSeconds").build()}).build();
    private static final SdkField<List<SlurmCustomSetting>> SLURM_CUSTOM_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("slurmCustomSettings").getter(UpdateClusterSlurmConfigurationRequest.getter(UpdateClusterSlurmConfigurationRequest::slurmCustomSettings)).setter(UpdateClusterSlurmConfigurationRequest.setter(Builder::slurmCustomSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slurmCustomSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SlurmCustomSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<UpdateAccountingRequest> ACCOUNTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("accounting").getter(UpdateClusterSlurmConfigurationRequest.getter(UpdateClusterSlurmConfigurationRequest::accounting)).setter(UpdateClusterSlurmConfigurationRequest.setter(Builder::accounting)).constructor(UpdateAccountingRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accounting").build()}).build();
    private static final SdkField<UpdateSlurmRestRequest> SLURM_REST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("slurmRest").getter(UpdateClusterSlurmConfigurationRequest.getter(UpdateClusterSlurmConfigurationRequest::slurmRest)).setter(UpdateClusterSlurmConfigurationRequest.setter(Builder::slurmRest)).constructor(UpdateSlurmRestRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slurmRest").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALE_DOWN_IDLE_TIME_IN_SECONDS_FIELD, SLURM_CUSTOM_SETTINGS_FIELD, ACCOUNTING_FIELD, SLURM_REST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateClusterSlurmConfigurationRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer scaleDownIdleTimeInSeconds;
    private final List<SlurmCustomSetting> slurmCustomSettings;
    private final UpdateAccountingRequest accounting;
    private final UpdateSlurmRestRequest slurmRest;

    private UpdateClusterSlurmConfigurationRequest(BuilderImpl builder) {
        this.scaleDownIdleTimeInSeconds = builder.scaleDownIdleTimeInSeconds;
        this.slurmCustomSettings = builder.slurmCustomSettings;
        this.accounting = builder.accounting;
        this.slurmRest = builder.slurmRest;
    }

    public final Integer scaleDownIdleTimeInSeconds() {
        return this.scaleDownIdleTimeInSeconds;
    }

    public final boolean hasSlurmCustomSettings() {
        return this.slurmCustomSettings != null && !(this.slurmCustomSettings instanceof SdkAutoConstructList);
    }

    public final List<SlurmCustomSetting> slurmCustomSettings() {
        return this.slurmCustomSettings;
    }

    public final UpdateAccountingRequest accounting() {
        return this.accounting;
    }

    public final UpdateSlurmRestRequest slurmRest() {
        return this.slurmRest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scaleDownIdleTimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSlurmCustomSettings() ? this.slurmCustomSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.accounting());
        hashCode = 31 * hashCode + Objects.hashCode(this.slurmRest());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateClusterSlurmConfigurationRequest)) {
            return false;
        }
        UpdateClusterSlurmConfigurationRequest other = (UpdateClusterSlurmConfigurationRequest)obj;
        return Objects.equals(this.scaleDownIdleTimeInSeconds(), other.scaleDownIdleTimeInSeconds()) && this.hasSlurmCustomSettings() == other.hasSlurmCustomSettings() && Objects.equals(this.slurmCustomSettings(), other.slurmCustomSettings()) && Objects.equals(this.accounting(), other.accounting()) && Objects.equals(this.slurmRest(), other.slurmRest());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateClusterSlurmConfigurationRequest").add("ScaleDownIdleTimeInSeconds", (Object)this.scaleDownIdleTimeInSeconds()).add("SlurmCustomSettings", this.hasSlurmCustomSettings() ? this.slurmCustomSettings() : null).add("Accounting", (Object)this.accounting()).add("SlurmRest", (Object)this.slurmRest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "scaleDownIdleTimeInSeconds": {
                return Optional.ofNullable(clazz.cast(this.scaleDownIdleTimeInSeconds()));
            }
            case "slurmCustomSettings": {
                return Optional.ofNullable(clazz.cast(this.slurmCustomSettings()));
            }
            case "accounting": {
                return Optional.ofNullable(clazz.cast(this.accounting()));
            }
            case "slurmRest": {
                return Optional.ofNullable(clazz.cast(this.slurmRest()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("scaleDownIdleTimeInSeconds", SCALE_DOWN_IDLE_TIME_IN_SECONDS_FIELD);
        map.put("slurmCustomSettings", SLURM_CUSTOM_SETTINGS_FIELD);
        map.put("accounting", ACCOUNTING_FIELD);
        map.put("slurmRest", SLURM_REST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateClusterSlurmConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateClusterSlurmConfigurationRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer scaleDownIdleTimeInSeconds;
        private List<SlurmCustomSetting> slurmCustomSettings = DefaultSdkAutoConstructList.getInstance();
        private UpdateAccountingRequest accounting;
        private UpdateSlurmRestRequest slurmRest;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateClusterSlurmConfigurationRequest model) {
            this.scaleDownIdleTimeInSeconds(model.scaleDownIdleTimeInSeconds);
            this.slurmCustomSettings(model.slurmCustomSettings);
            this.accounting(model.accounting);
            this.slurmRest(model.slurmRest);
        }

        public final Integer getScaleDownIdleTimeInSeconds() {
            return this.scaleDownIdleTimeInSeconds;
        }

        public final void setScaleDownIdleTimeInSeconds(Integer scaleDownIdleTimeInSeconds) {
            this.scaleDownIdleTimeInSeconds = scaleDownIdleTimeInSeconds;
        }

        @Override
        public final Builder scaleDownIdleTimeInSeconds(Integer scaleDownIdleTimeInSeconds) {
            this.scaleDownIdleTimeInSeconds = scaleDownIdleTimeInSeconds;
            return this;
        }

        public final List<SlurmCustomSetting.Builder> getSlurmCustomSettings() {
            List<SlurmCustomSetting.Builder> result = SlurmCustomSettingsCopier.copyToBuilder(this.slurmCustomSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSlurmCustomSettings(Collection<SlurmCustomSetting.BuilderImpl> slurmCustomSettings) {
            this.slurmCustomSettings = SlurmCustomSettingsCopier.copyFromBuilder(slurmCustomSettings);
        }

        @Override
        public final Builder slurmCustomSettings(Collection<SlurmCustomSetting> slurmCustomSettings) {
            this.slurmCustomSettings = SlurmCustomSettingsCopier.copy(slurmCustomSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slurmCustomSettings(SlurmCustomSetting ... slurmCustomSettings) {
            this.slurmCustomSettings(Arrays.asList(slurmCustomSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slurmCustomSettings(Consumer<SlurmCustomSetting.Builder> ... slurmCustomSettings) {
            this.slurmCustomSettings(Stream.of(slurmCustomSettings).map(c -> (SlurmCustomSetting)((SlurmCustomSetting.Builder)SlurmCustomSetting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final UpdateAccountingRequest.Builder getAccounting() {
            return this.accounting != null ? this.accounting.toBuilder() : null;
        }

        public final void setAccounting(UpdateAccountingRequest.BuilderImpl accounting) {
            this.accounting = accounting != null ? accounting.build() : null;
        }

        @Override
        public final Builder accounting(UpdateAccountingRequest accounting) {
            this.accounting = accounting;
            return this;
        }

        public final UpdateSlurmRestRequest.Builder getSlurmRest() {
            return this.slurmRest != null ? this.slurmRest.toBuilder() : null;
        }

        public final void setSlurmRest(UpdateSlurmRestRequest.BuilderImpl slurmRest) {
            this.slurmRest = slurmRest != null ? slurmRest.build() : null;
        }

        @Override
        public final Builder slurmRest(UpdateSlurmRestRequest slurmRest) {
            this.slurmRest = slurmRest;
            return this;
        }

        public UpdateClusterSlurmConfigurationRequest build() {
            return new UpdateClusterSlurmConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateClusterSlurmConfigurationRequest> {
        public Builder scaleDownIdleTimeInSeconds(Integer var1);

        public Builder slurmCustomSettings(Collection<SlurmCustomSetting> var1);

        public Builder slurmCustomSettings(SlurmCustomSetting ... var1);

        public Builder slurmCustomSettings(Consumer<SlurmCustomSetting.Builder> ... var1);

        public Builder accounting(UpdateAccountingRequest var1);

        default public Builder accounting(Consumer<UpdateAccountingRequest.Builder> accounting) {
            return this.accounting((UpdateAccountingRequest)((UpdateAccountingRequest.Builder)UpdateAccountingRequest.builder().applyMutation(accounting)).build());
        }

        public Builder slurmRest(UpdateSlurmRestRequest var1);

        default public Builder slurmRest(Consumer<UpdateSlurmRestRequest.Builder> slurmRest) {
            return this.slurmRest((UpdateSlurmRestRequest)((UpdateSlurmRestRequest.Builder)UpdateSlurmRestRequest.builder().applyMutation(slurmRest)).build());
        }
    }
}

