/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pcs.model.CustomLaunchTemplate;
import software.amazon.awssdk.services.pcs.model.PcsRequest;
import software.amazon.awssdk.services.pcs.model.PurchaseOption;
import software.amazon.awssdk.services.pcs.model.ScalingConfigurationRequest;
import software.amazon.awssdk.services.pcs.model.SpotOptions;
import software.amazon.awssdk.services.pcs.model.StringListCopier;
import software.amazon.awssdk.services.pcs.model.UpdateComputeNodeGroupSlurmConfigurationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateComputeNodeGroupRequest
extends PcsRequest
implements ToCopyableBuilder<Builder, UpdateComputeNodeGroupRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterIdentifier").getter(UpdateComputeNodeGroupRequest.getter(UpdateComputeNodeGroupRequest::clusterIdentifier)).setter(UpdateComputeNodeGroupRequest.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterIdentifier").build()}).build();
    private static final SdkField<String> COMPUTE_NODE_GROUP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computeNodeGroupIdentifier").getter(UpdateComputeNodeGroupRequest.getter(UpdateComputeNodeGroupRequest::computeNodeGroupIdentifier)).setter(UpdateComputeNodeGroupRequest.setter(Builder::computeNodeGroupIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeNodeGroupIdentifier").build()}).build();
    private static final SdkField<String> AMI_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("amiId").getter(UpdateComputeNodeGroupRequest.getter(UpdateComputeNodeGroupRequest::amiId)).setter(UpdateComputeNodeGroupRequest.setter(Builder::amiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amiId").build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("subnetIds").getter(UpdateComputeNodeGroupRequest.getter(UpdateComputeNodeGroupRequest::subnetIds)).setter(UpdateComputeNodeGroupRequest.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CustomLaunchTemplate> CUSTOM_LAUNCH_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("customLaunchTemplate").getter(UpdateComputeNodeGroupRequest.getter(UpdateComputeNodeGroupRequest::customLaunchTemplate)).setter(UpdateComputeNodeGroupRequest.setter(Builder::customLaunchTemplate)).constructor(CustomLaunchTemplate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customLaunchTemplate").build()}).build();
    private static final SdkField<String> PURCHASE_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("purchaseOption").getter(UpdateComputeNodeGroupRequest.getter(UpdateComputeNodeGroupRequest::purchaseOptionAsString)).setter(UpdateComputeNodeGroupRequest.setter(Builder::purchaseOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("purchaseOption").build()}).build();
    private static final SdkField<SpotOptions> SPOT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("spotOptions").getter(UpdateComputeNodeGroupRequest.getter(UpdateComputeNodeGroupRequest::spotOptions)).setter(UpdateComputeNodeGroupRequest.setter(Builder::spotOptions)).constructor(SpotOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spotOptions").build()}).build();
    private static final SdkField<ScalingConfigurationRequest> SCALING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scalingConfiguration").getter(UpdateComputeNodeGroupRequest.getter(UpdateComputeNodeGroupRequest::scalingConfiguration)).setter(UpdateComputeNodeGroupRequest.setter(Builder::scalingConfiguration)).constructor(ScalingConfigurationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalingConfiguration").build()}).build();
    private static final SdkField<String> IAM_INSTANCE_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("iamInstanceProfileArn").getter(UpdateComputeNodeGroupRequest.getter(UpdateComputeNodeGroupRequest::iamInstanceProfileArn)).setter(UpdateComputeNodeGroupRequest.setter(Builder::iamInstanceProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamInstanceProfileArn").build()}).build();
    private static final SdkField<UpdateComputeNodeGroupSlurmConfigurationRequest> SLURM_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("slurmConfiguration").getter(UpdateComputeNodeGroupRequest.getter(UpdateComputeNodeGroupRequest::slurmConfiguration)).setter(UpdateComputeNodeGroupRequest.setter(Builder::slurmConfiguration)).constructor(UpdateComputeNodeGroupSlurmConfigurationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slurmConfiguration").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateComputeNodeGroupRequest.getter(UpdateComputeNodeGroupRequest::clientToken)).setter(UpdateComputeNodeGroupRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD, COMPUTE_NODE_GROUP_IDENTIFIER_FIELD, AMI_ID_FIELD, SUBNET_IDS_FIELD, CUSTOM_LAUNCH_TEMPLATE_FIELD, PURCHASE_OPTION_FIELD, SPOT_OPTIONS_FIELD, SCALING_CONFIGURATION_FIELD, IAM_INSTANCE_PROFILE_ARN_FIELD, SLURM_CONFIGURATION_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateComputeNodeGroupRequest.memberNameToFieldInitializer();
    private final String clusterIdentifier;
    private final String computeNodeGroupIdentifier;
    private final String amiId;
    private final List<String> subnetIds;
    private final CustomLaunchTemplate customLaunchTemplate;
    private final String purchaseOption;
    private final SpotOptions spotOptions;
    private final ScalingConfigurationRequest scalingConfiguration;
    private final String iamInstanceProfileArn;
    private final UpdateComputeNodeGroupSlurmConfigurationRequest slurmConfiguration;
    private final String clientToken;

    private UpdateComputeNodeGroupRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.computeNodeGroupIdentifier = builder.computeNodeGroupIdentifier;
        this.amiId = builder.amiId;
        this.subnetIds = builder.subnetIds;
        this.customLaunchTemplate = builder.customLaunchTemplate;
        this.purchaseOption = builder.purchaseOption;
        this.spotOptions = builder.spotOptions;
        this.scalingConfiguration = builder.scalingConfiguration;
        this.iamInstanceProfileArn = builder.iamInstanceProfileArn;
        this.slurmConfiguration = builder.slurmConfiguration;
        this.clientToken = builder.clientToken;
    }

    public final String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public final String computeNodeGroupIdentifier() {
        return this.computeNodeGroupIdentifier;
    }

    public final String amiId() {
        return this.amiId;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final CustomLaunchTemplate customLaunchTemplate() {
        return this.customLaunchTemplate;
    }

    public final PurchaseOption purchaseOption() {
        return PurchaseOption.fromValue(this.purchaseOption);
    }

    public final String purchaseOptionAsString() {
        return this.purchaseOption;
    }

    public final SpotOptions spotOptions() {
        return this.spotOptions;
    }

    public final ScalingConfigurationRequest scalingConfiguration() {
        return this.scalingConfiguration;
    }

    public final String iamInstanceProfileArn() {
        return this.iamInstanceProfileArn;
    }

    public final UpdateComputeNodeGroupSlurmConfigurationRequest slurmConfiguration() {
        return this.slurmConfiguration;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeNodeGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.amiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.customLaunchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.purchaseOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamInstanceProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.slurmConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateComputeNodeGroupRequest)) {
            return false;
        }
        UpdateComputeNodeGroupRequest other = (UpdateComputeNodeGroupRequest)((Object)obj);
        return Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.computeNodeGroupIdentifier(), other.computeNodeGroupIdentifier()) && Objects.equals(this.amiId(), other.amiId()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && Objects.equals(this.customLaunchTemplate(), other.customLaunchTemplate()) && Objects.equals(this.purchaseOptionAsString(), other.purchaseOptionAsString()) && Objects.equals(this.spotOptions(), other.spotOptions()) && Objects.equals(this.scalingConfiguration(), other.scalingConfiguration()) && Objects.equals(this.iamInstanceProfileArn(), other.iamInstanceProfileArn()) && Objects.equals(this.slurmConfiguration(), other.slurmConfiguration()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateComputeNodeGroupRequest").add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("ComputeNodeGroupIdentifier", (Object)this.computeNodeGroupIdentifier()).add("AmiId", (Object)this.amiId()).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("CustomLaunchTemplate", (Object)this.customLaunchTemplate()).add("PurchaseOption", (Object)this.purchaseOptionAsString()).add("SpotOptions", (Object)this.spotOptions()).add("ScalingConfiguration", (Object)this.scalingConfiguration()).add("IamInstanceProfileArn", (Object)this.iamInstanceProfileArn()).add("SlurmConfiguration", (Object)this.slurmConfiguration()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "computeNodeGroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.computeNodeGroupIdentifier()));
            }
            case "amiId": {
                return Optional.ofNullable(clazz.cast(this.amiId()));
            }
            case "subnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "customLaunchTemplate": {
                return Optional.ofNullable(clazz.cast(this.customLaunchTemplate()));
            }
            case "purchaseOption": {
                return Optional.ofNullable(clazz.cast(this.purchaseOptionAsString()));
            }
            case "spotOptions": {
                return Optional.ofNullable(clazz.cast(this.spotOptions()));
            }
            case "scalingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.scalingConfiguration()));
            }
            case "iamInstanceProfileArn": {
                return Optional.ofNullable(clazz.cast(this.iamInstanceProfileArn()));
            }
            case "slurmConfiguration": {
                return Optional.ofNullable(clazz.cast(this.slurmConfiguration()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clusterIdentifier", CLUSTER_IDENTIFIER_FIELD);
        map.put("computeNodeGroupIdentifier", COMPUTE_NODE_GROUP_IDENTIFIER_FIELD);
        map.put("amiId", AMI_ID_FIELD);
        map.put("subnetIds", SUBNET_IDS_FIELD);
        map.put("customLaunchTemplate", CUSTOM_LAUNCH_TEMPLATE_FIELD);
        map.put("purchaseOption", PURCHASE_OPTION_FIELD);
        map.put("spotOptions", SPOT_OPTIONS_FIELD);
        map.put("scalingConfiguration", SCALING_CONFIGURATION_FIELD);
        map.put("iamInstanceProfileArn", IAM_INSTANCE_PROFILE_ARN_FIELD);
        map.put("slurmConfiguration", SLURM_CONFIGURATION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateComputeNodeGroupRequest, T> g) {
        return obj -> g.apply((UpdateComputeNodeGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PcsRequest.BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private String computeNodeGroupIdentifier;
        private String amiId;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private CustomLaunchTemplate customLaunchTemplate;
        private String purchaseOption;
        private SpotOptions spotOptions;
        private ScalingConfigurationRequest scalingConfiguration;
        private String iamInstanceProfileArn;
        private UpdateComputeNodeGroupSlurmConfigurationRequest slurmConfiguration;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateComputeNodeGroupRequest model) {
            super(model);
            this.clusterIdentifier(model.clusterIdentifier);
            this.computeNodeGroupIdentifier(model.computeNodeGroupIdentifier);
            this.amiId(model.amiId);
            this.subnetIds(model.subnetIds);
            this.customLaunchTemplate(model.customLaunchTemplate);
            this.purchaseOption(model.purchaseOption);
            this.spotOptions(model.spotOptions);
            this.scalingConfiguration(model.scalingConfiguration);
            this.iamInstanceProfileArn(model.iamInstanceProfileArn);
            this.slurmConfiguration(model.slurmConfiguration);
            this.clientToken(model.clientToken);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getComputeNodeGroupIdentifier() {
            return this.computeNodeGroupIdentifier;
        }

        public final void setComputeNodeGroupIdentifier(String computeNodeGroupIdentifier) {
            this.computeNodeGroupIdentifier = computeNodeGroupIdentifier;
        }

        @Override
        public final Builder computeNodeGroupIdentifier(String computeNodeGroupIdentifier) {
            this.computeNodeGroupIdentifier = computeNodeGroupIdentifier;
            return this;
        }

        public final String getAmiId() {
            return this.amiId;
        }

        public final void setAmiId(String amiId) {
            this.amiId = amiId;
        }

        @Override
        public final Builder amiId(String amiId) {
            this.amiId = amiId;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final CustomLaunchTemplate.Builder getCustomLaunchTemplate() {
            return this.customLaunchTemplate != null ? this.customLaunchTemplate.toBuilder() : null;
        }

        public final void setCustomLaunchTemplate(CustomLaunchTemplate.BuilderImpl customLaunchTemplate) {
            this.customLaunchTemplate = customLaunchTemplate != null ? customLaunchTemplate.build() : null;
        }

        @Override
        public final Builder customLaunchTemplate(CustomLaunchTemplate customLaunchTemplate) {
            this.customLaunchTemplate = customLaunchTemplate;
            return this;
        }

        public final String getPurchaseOption() {
            return this.purchaseOption;
        }

        public final void setPurchaseOption(String purchaseOption) {
            this.purchaseOption = purchaseOption;
        }

        @Override
        public final Builder purchaseOption(String purchaseOption) {
            this.purchaseOption = purchaseOption;
            return this;
        }

        @Override
        public final Builder purchaseOption(PurchaseOption purchaseOption) {
            this.purchaseOption(purchaseOption == null ? null : purchaseOption.toString());
            return this;
        }

        public final SpotOptions.Builder getSpotOptions() {
            return this.spotOptions != null ? this.spotOptions.toBuilder() : null;
        }

        public final void setSpotOptions(SpotOptions.BuilderImpl spotOptions) {
            this.spotOptions = spotOptions != null ? spotOptions.build() : null;
        }

        @Override
        public final Builder spotOptions(SpotOptions spotOptions) {
            this.spotOptions = spotOptions;
            return this;
        }

        public final ScalingConfigurationRequest.Builder getScalingConfiguration() {
            return this.scalingConfiguration != null ? this.scalingConfiguration.toBuilder() : null;
        }

        public final void setScalingConfiguration(ScalingConfigurationRequest.BuilderImpl scalingConfiguration) {
            this.scalingConfiguration = scalingConfiguration != null ? scalingConfiguration.build() : null;
        }

        @Override
        public final Builder scalingConfiguration(ScalingConfigurationRequest scalingConfiguration) {
            this.scalingConfiguration = scalingConfiguration;
            return this;
        }

        public final String getIamInstanceProfileArn() {
            return this.iamInstanceProfileArn;
        }

        public final void setIamInstanceProfileArn(String iamInstanceProfileArn) {
            this.iamInstanceProfileArn = iamInstanceProfileArn;
        }

        @Override
        public final Builder iamInstanceProfileArn(String iamInstanceProfileArn) {
            this.iamInstanceProfileArn = iamInstanceProfileArn;
            return this;
        }

        public final UpdateComputeNodeGroupSlurmConfigurationRequest.Builder getSlurmConfiguration() {
            return this.slurmConfiguration != null ? this.slurmConfiguration.toBuilder() : null;
        }

        public final void setSlurmConfiguration(UpdateComputeNodeGroupSlurmConfigurationRequest.BuilderImpl slurmConfiguration) {
            this.slurmConfiguration = slurmConfiguration != null ? slurmConfiguration.build() : null;
        }

        @Override
        public final Builder slurmConfiguration(UpdateComputeNodeGroupSlurmConfigurationRequest slurmConfiguration) {
            this.slurmConfiguration = slurmConfiguration;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateComputeNodeGroupRequest build() {
            return new UpdateComputeNodeGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateComputeNodeGroupRequest> {
        public Builder clusterIdentifier(String var1);

        public Builder computeNodeGroupIdentifier(String var1);

        public Builder amiId(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder customLaunchTemplate(CustomLaunchTemplate var1);

        default public Builder customLaunchTemplate(Consumer<CustomLaunchTemplate.Builder> customLaunchTemplate) {
            return this.customLaunchTemplate((CustomLaunchTemplate)((CustomLaunchTemplate.Builder)CustomLaunchTemplate.builder().applyMutation(customLaunchTemplate)).build());
        }

        public Builder purchaseOption(String var1);

        public Builder purchaseOption(PurchaseOption var1);

        public Builder spotOptions(SpotOptions var1);

        default public Builder spotOptions(Consumer<SpotOptions.Builder> spotOptions) {
            return this.spotOptions((SpotOptions)((SpotOptions.Builder)SpotOptions.builder().applyMutation(spotOptions)).build());
        }

        public Builder scalingConfiguration(ScalingConfigurationRequest var1);

        default public Builder scalingConfiguration(Consumer<ScalingConfigurationRequest.Builder> scalingConfiguration) {
            return this.scalingConfiguration((ScalingConfigurationRequest)((ScalingConfigurationRequest.Builder)ScalingConfigurationRequest.builder().applyMutation(scalingConfiguration)).build());
        }

        public Builder iamInstanceProfileArn(String var1);

        public Builder slurmConfiguration(UpdateComputeNodeGroupSlurmConfigurationRequest var1);

        default public Builder slurmConfiguration(Consumer<UpdateComputeNodeGroupSlurmConfigurationRequest.Builder> slurmConfiguration) {
            return this.slurmConfiguration((UpdateComputeNodeGroupSlurmConfigurationRequest)((UpdateComputeNodeGroupSlurmConfigurationRequest.Builder)UpdateComputeNodeGroupSlurmConfigurationRequest.builder().applyMutation(slurmConfiguration)).build());
        }

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

