/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum QueueStatus {
    CREATING("CREATING"),
    ACTIVE("ACTIVE"),
    UPDATING("UPDATING"),
    DELETING("DELETING"),
    CREATE_FAILED("CREATE_FAILED"),
    DELETE_FAILED("DELETE_FAILED"),
    UPDATE_FAILED("UPDATE_FAILED"),
    SUSPENDING("SUSPENDING"),
    SUSPENDED("SUSPENDED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, QueueStatus> VALUE_MAP;
    private final String value;

    private QueueStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static QueueStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<QueueStatus> knownValues() {
        EnumSet<QueueStatus> knownValues = EnumSet.allOf(QueueStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(QueueStatus.class, QueueStatus::toString);
    }
}

