/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pcs.model.AccountingMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountingRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountingRequest> {
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mode").getter(AccountingRequest.getter(AccountingRequest::modeAsString)).setter(AccountingRequest.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()}).build();
    private static final SdkField<Integer> DEFAULT_PURGE_TIME_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("defaultPurgeTimeInDays").getter(AccountingRequest.getter(AccountingRequest::defaultPurgeTimeInDays)).setter(AccountingRequest.setter(Builder::defaultPurgeTimeInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultPurgeTimeInDays").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD, DEFAULT_PURGE_TIME_IN_DAYS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AccountingRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String mode;
    private final Integer defaultPurgeTimeInDays;

    private AccountingRequest(BuilderImpl builder) {
        this.mode = builder.mode;
        this.defaultPurgeTimeInDays = builder.defaultPurgeTimeInDays;
    }

    public final AccountingMode mode() {
        return AccountingMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final Integer defaultPurgeTimeInDays() {
        return this.defaultPurgeTimeInDays;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultPurgeTimeInDays());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountingRequest)) {
            return false;
        }
        AccountingRequest other = (AccountingRequest)obj;
        return Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.defaultPurgeTimeInDays(), other.defaultPurgeTimeInDays());
    }

    public final String toString() {
        return ToString.builder((String)"AccountingRequest").add("Mode", (Object)this.modeAsString()).add("DefaultPurgeTimeInDays", (Object)this.defaultPurgeTimeInDays()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "defaultPurgeTimeInDays": {
                return Optional.ofNullable(clazz.cast(this.defaultPurgeTimeInDays()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mode", MODE_FIELD);
        map.put("defaultPurgeTimeInDays", DEFAULT_PURGE_TIME_IN_DAYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountingRequest, T> g) {
        return obj -> g.apply((AccountingRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mode;
        private Integer defaultPurgeTimeInDays;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountingRequest model) {
            this.mode(model.mode);
            this.defaultPurgeTimeInDays(model.defaultPurgeTimeInDays);
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(AccountingMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final Integer getDefaultPurgeTimeInDays() {
            return this.defaultPurgeTimeInDays;
        }

        public final void setDefaultPurgeTimeInDays(Integer defaultPurgeTimeInDays) {
            this.defaultPurgeTimeInDays = defaultPurgeTimeInDays;
        }

        @Override
        public final Builder defaultPurgeTimeInDays(Integer defaultPurgeTimeInDays) {
            this.defaultPurgeTimeInDays = defaultPurgeTimeInDays;
            return this;
        }

        public AccountingRequest build() {
            return new AccountingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountingRequest> {
        public Builder mode(String var1);

        public Builder mode(AccountingMode var1);

        public Builder defaultPurgeTimeInDays(Integer var1);
    }
}

