/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pcs.PcsAsyncClient;
import software.amazon.awssdk.services.pcs.internal.UserAgentUtils;
import software.amazon.awssdk.services.pcs.model.ComputeNodeGroupSummary;
import software.amazon.awssdk.services.pcs.model.ListComputeNodeGroupsRequest;
import software.amazon.awssdk.services.pcs.model.ListComputeNodeGroupsResponse;

public class ListComputeNodeGroupsPublisher
implements SdkPublisher<ListComputeNodeGroupsResponse> {
    private final PcsAsyncClient client;
    private final ListComputeNodeGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListComputeNodeGroupsPublisher(PcsAsyncClient client, ListComputeNodeGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListComputeNodeGroupsPublisher(PcsAsyncClient client, ListComputeNodeGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListComputeNodeGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListComputeNodeGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ComputeNodeGroupSummary> computeNodeGroups() {
        Function<ListComputeNodeGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.computeNodeGroups() != null) {
                return response.computeNodeGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListComputeNodeGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListComputeNodeGroupsResponseFetcher
    implements AsyncPageFetcher<ListComputeNodeGroupsResponse> {
        private ListComputeNodeGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListComputeNodeGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListComputeNodeGroupsResponse> nextPage(ListComputeNodeGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListComputeNodeGroupsPublisher.this.client.listComputeNodeGroups(ListComputeNodeGroupsPublisher.this.firstRequest);
            }
            return ListComputeNodeGroupsPublisher.this.client.listComputeNodeGroups((ListComputeNodeGroupsRequest)((Object)ListComputeNodeGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

