/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pcs.PcsClient;
import software.amazon.awssdk.services.pcs.internal.UserAgentUtils;
import software.amazon.awssdk.services.pcs.model.ListQueuesRequest;
import software.amazon.awssdk.services.pcs.model.ListQueuesResponse;
import software.amazon.awssdk.services.pcs.model.QueueSummary;

public class ListQueuesIterable
implements SdkIterable<ListQueuesResponse> {
    private final PcsClient client;
    private final ListQueuesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListQueuesIterable(PcsClient client, ListQueuesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListQueuesResponseFetcher();
    }

    public Iterator<ListQueuesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<QueueSummary> queues() {
        Function<ListQueuesResponse, Iterator> getIterator = response -> {
            if (response != null && response.queues() != null) {
                return response.queues().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListQueuesResponseFetcher
    implements SyncPageFetcher<ListQueuesResponse> {
        private ListQueuesResponseFetcher() {
        }

        public boolean hasNextPage(ListQueuesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListQueuesResponse nextPage(ListQueuesResponse previousPage) {
            if (previousPage == null) {
                return ListQueuesIterable.this.client.listQueues(ListQueuesIterable.this.firstRequest);
            }
            return ListQueuesIterable.this.client.listQueues((ListQueuesRequest)((Object)ListQueuesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

