/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pcs.PcsClient;
import software.amazon.awssdk.services.pcs.internal.UserAgentUtils;
import software.amazon.awssdk.services.pcs.model.ClusterSummary;
import software.amazon.awssdk.services.pcs.model.ListClustersRequest;
import software.amazon.awssdk.services.pcs.model.ListClustersResponse;

public class ListClustersIterable
implements SdkIterable<ListClustersResponse> {
    private final PcsClient client;
    private final ListClustersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListClustersIterable(PcsClient client, ListClustersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListClustersResponseFetcher();
    }

    public Iterator<ListClustersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ClusterSummary> clusters() {
        Function<ListClustersResponse, Iterator> getIterator = response -> {
            if (response != null && response.clusters() != null) {
                return response.clusters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListClustersResponseFetcher
    implements SyncPageFetcher<ListClustersResponse> {
        private ListClustersResponseFetcher() {
        }

        public boolean hasNextPage(ListClustersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListClustersResponse nextPage(ListClustersResponse previousPage) {
            if (previousPage == null) {
                return ListClustersIterable.this.client.listClusters(ListClustersIterable.this.firstRequest);
            }
            return ListClustersIterable.this.client.listClusters((ListClustersRequest)((Object)ListClustersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

