/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorscep.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pcaconnectorscep.model.ConnectorStatus;
import software.amazon.awssdk.services.pcaconnectorscep.model.ConnectorStatusReason;
import software.amazon.awssdk.services.pcaconnectorscep.model.ConnectorType;
import software.amazon.awssdk.services.pcaconnectorscep.model.MobileDeviceManagement;
import software.amazon.awssdk.services.pcaconnectorscep.model.OpenIdConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectorSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectorSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ConnectorSummary.getter(ConnectorSummary::arn)).setter(ConnectorSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> CERTIFICATE_AUTHORITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateAuthorityArn").getter(ConnectorSummary.getter(ConnectorSummary::certificateAuthorityArn)).setter(ConnectorSummary.setter(Builder::certificateAuthorityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityArn").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ConnectorSummary.getter(ConnectorSummary::typeAsString)).setter(ConnectorSummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<MobileDeviceManagement> MOBILE_DEVICE_MANAGEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MobileDeviceManagement").getter(ConnectorSummary.getter(ConnectorSummary::mobileDeviceManagement)).setter(ConnectorSummary.setter(Builder::mobileDeviceManagement)).constructor(MobileDeviceManagement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MobileDeviceManagement").build()}).build();
    private static final SdkField<OpenIdConfiguration> OPEN_ID_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OpenIdConfiguration").getter(ConnectorSummary.getter(ConnectorSummary::openIdConfiguration)).setter(ConnectorSummary.setter(Builder::openIdConfiguration)).constructor(OpenIdConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenIdConfiguration").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ConnectorSummary.getter(ConnectorSummary::statusAsString)).setter(ConnectorSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(ConnectorSummary.getter(ConnectorSummary::statusReasonAsString)).setter(ConnectorSummary.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Endpoint").getter(ConnectorSummary.getter(ConnectorSummary::endpoint)).setter(ConnectorSummary.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(ConnectorSummary.getter(ConnectorSummary::createdAt)).setter(ConnectorSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(ConnectorSummary.getter(ConnectorSummary::updatedAt)).setter(ConnectorSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CERTIFICATE_AUTHORITY_ARN_FIELD, TYPE_FIELD, MOBILE_DEVICE_MANAGEMENT_FIELD, OPEN_ID_CONFIGURATION_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, ENDPOINT_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConnectorSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String certificateAuthorityArn;
    private final String type;
    private final MobileDeviceManagement mobileDeviceManagement;
    private final OpenIdConfiguration openIdConfiguration;
    private final String status;
    private final String statusReason;
    private final String endpoint;
    private final Instant createdAt;
    private final Instant updatedAt;

    private ConnectorSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.certificateAuthorityArn = builder.certificateAuthorityArn;
        this.type = builder.type;
        this.mobileDeviceManagement = builder.mobileDeviceManagement;
        this.openIdConfiguration = builder.openIdConfiguration;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.endpoint = builder.endpoint;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    public final String arn() {
        return this.arn;
    }

    public final String certificateAuthorityArn() {
        return this.certificateAuthorityArn;
    }

    public final ConnectorType type() {
        return ConnectorType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final MobileDeviceManagement mobileDeviceManagement() {
        return this.mobileDeviceManagement;
    }

    public final OpenIdConfiguration openIdConfiguration() {
        return this.openIdConfiguration;
    }

    public final ConnectorStatus status() {
        return ConnectorStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ConnectorStatusReason statusReason() {
        return ConnectorStatusReason.fromValue(this.statusReason);
    }

    public final String statusReasonAsString() {
        return this.statusReason;
    }

    public final String endpoint() {
        return this.endpoint;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateAuthorityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mobileDeviceManagement());
        hashCode = 31 * hashCode + Objects.hashCode(this.openIdConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorSummary)) {
            return false;
        }
        ConnectorSummary other = (ConnectorSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.certificateAuthorityArn(), other.certificateAuthorityArn()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.mobileDeviceManagement(), other.mobileDeviceManagement()) && Objects.equals(this.openIdConfiguration(), other.openIdConfiguration()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReasonAsString(), other.statusReasonAsString()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectorSummary").add("Arn", (Object)this.arn()).add("CertificateAuthorityArn", (Object)this.certificateAuthorityArn()).add("Type", (Object)this.typeAsString()).add("MobileDeviceManagement", (Object)this.mobileDeviceManagement()).add("OpenIdConfiguration", (Object)this.openIdConfiguration()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReasonAsString()).add("Endpoint", (Object)this.endpoint()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CertificateAuthorityArn": {
                return Optional.ofNullable(clazz.cast(this.certificateAuthorityArn()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "MobileDeviceManagement": {
                return Optional.ofNullable(clazz.cast(this.mobileDeviceManagement()));
            }
            case "OpenIdConfiguration": {
                return Optional.ofNullable(clazz.cast(this.openIdConfiguration()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReasonAsString()));
            }
            case "Endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("CertificateAuthorityArn", CERTIFICATE_AUTHORITY_ARN_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("MobileDeviceManagement", MOBILE_DEVICE_MANAGEMENT_FIELD);
        map.put("OpenIdConfiguration", OPEN_ID_CONFIGURATION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        map.put("Endpoint", ENDPOINT_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectorSummary, T> g) {
        return obj -> g.apply((ConnectorSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String certificateAuthorityArn;
        private String type;
        private MobileDeviceManagement mobileDeviceManagement;
        private OpenIdConfiguration openIdConfiguration;
        private String status;
        private String statusReason;
        private String endpoint;
        private Instant createdAt;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorSummary model) {
            this.arn(model.arn);
            this.certificateAuthorityArn(model.certificateAuthorityArn);
            this.type(model.type);
            this.mobileDeviceManagement(model.mobileDeviceManagement);
            this.openIdConfiguration(model.openIdConfiguration);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.endpoint(model.endpoint);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCertificateAuthorityArn() {
            return this.certificateAuthorityArn;
        }

        public final void setCertificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
        }

        @Override
        public final Builder certificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ConnectorType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final MobileDeviceManagement.Builder getMobileDeviceManagement() {
            return this.mobileDeviceManagement != null ? this.mobileDeviceManagement.toBuilder() : null;
        }

        public final void setMobileDeviceManagement(MobileDeviceManagement.BuilderImpl mobileDeviceManagement) {
            this.mobileDeviceManagement = mobileDeviceManagement != null ? mobileDeviceManagement.build() : null;
        }

        @Override
        public final Builder mobileDeviceManagement(MobileDeviceManagement mobileDeviceManagement) {
            this.mobileDeviceManagement = mobileDeviceManagement;
            return this;
        }

        public final OpenIdConfiguration.Builder getOpenIdConfiguration() {
            return this.openIdConfiguration != null ? this.openIdConfiguration.toBuilder() : null;
        }

        public final void setOpenIdConfiguration(OpenIdConfiguration.BuilderImpl openIdConfiguration) {
            this.openIdConfiguration = openIdConfiguration != null ? openIdConfiguration.build() : null;
        }

        @Override
        public final Builder openIdConfiguration(OpenIdConfiguration openIdConfiguration) {
            this.openIdConfiguration = openIdConfiguration;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ConnectorStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public final Builder statusReason(ConnectorStatusReason statusReason) {
            this.statusReason(statusReason == null ? null : statusReason.toString());
            return this;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public ConnectorSummary build() {
            return new ConnectorSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectorSummary> {
        public Builder arn(String var1);

        public Builder certificateAuthorityArn(String var1);

        public Builder type(String var1);

        public Builder type(ConnectorType var1);

        public Builder mobileDeviceManagement(MobileDeviceManagement var1);

        default public Builder mobileDeviceManagement(Consumer<MobileDeviceManagement.Builder> mobileDeviceManagement) {
            return this.mobileDeviceManagement((MobileDeviceManagement)((MobileDeviceManagement.Builder)MobileDeviceManagement.builder().applyMutation(mobileDeviceManagement)).build());
        }

        public Builder openIdConfiguration(OpenIdConfiguration var1);

        default public Builder openIdConfiguration(Consumer<OpenIdConfiguration.Builder> openIdConfiguration) {
            return this.openIdConfiguration((OpenIdConfiguration)((OpenIdConfiguration.Builder)OpenIdConfiguration.builder().applyMutation(openIdConfiguration)).build());
        }

        public Builder status(String var1);

        public Builder status(ConnectorStatus var1);

        public Builder statusReason(String var1);

        public Builder statusReason(ConnectorStatusReason var1);

        public Builder endpoint(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);
    }
}

