/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorad.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ValidationExceptionReason {
    FIELD_VALIDATION_FAILED("FIELD_VALIDATION_FAILED"),
    INVALID_CA_SUBJECT("INVALID_CA_SUBJECT"),
    INVALID_PERMISSION("INVALID_PERMISSION"),
    INVALID_STATE("INVALID_STATE"),
    MISMATCHED_CONNECTOR("MISMATCHED_CONNECTOR"),
    MISMATCHED_VPC("MISMATCHED_VPC"),
    NO_CLIENT_TOKEN("NO_CLIENT_TOKEN"),
    UNKNOWN_OPERATION("UNKNOWN_OPERATION"),
    OTHER("OTHER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ValidationExceptionReason> VALUE_MAP;
    private final String value;

    private ValidationExceptionReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ValidationExceptionReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ValidationExceptionReason> knownValues() {
        EnumSet<ValidationExceptionReason> knownValues = EnumSet.allOf(ValidationExceptionReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ValidationExceptionReason.class, ValidationExceptionReason::toString);
    }
}

