/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorad.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pcaconnectorad.PcaConnectorAdClient;
import software.amazon.awssdk.services.pcaconnectorad.internal.UserAgentUtils;
import software.amazon.awssdk.services.pcaconnectorad.model.DirectoryRegistrationSummary;
import software.amazon.awssdk.services.pcaconnectorad.model.ListDirectoryRegistrationsRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.ListDirectoryRegistrationsResponse;

public class ListDirectoryRegistrationsIterable
implements SdkIterable<ListDirectoryRegistrationsResponse> {
    private final PcaConnectorAdClient client;
    private final ListDirectoryRegistrationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDirectoryRegistrationsIterable(PcaConnectorAdClient client, ListDirectoryRegistrationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDirectoryRegistrationsResponseFetcher();
    }

    public Iterator<ListDirectoryRegistrationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DirectoryRegistrationSummary> directoryRegistrations() {
        Function<ListDirectoryRegistrationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.directoryRegistrations() != null) {
                return response.directoryRegistrations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDirectoryRegistrationsResponseFetcher
    implements SyncPageFetcher<ListDirectoryRegistrationsResponse> {
        private ListDirectoryRegistrationsResponseFetcher() {
        }

        public boolean hasNextPage(ListDirectoryRegistrationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDirectoryRegistrationsResponse nextPage(ListDirectoryRegistrationsResponse previousPage) {
            if (previousPage == null) {
                return ListDirectoryRegistrationsIterable.this.client.listDirectoryRegistrations(ListDirectoryRegistrationsIterable.this.firstRequest);
            }
            return ListDirectoryRegistrationsIterable.this.client.listDirectoryRegistrations((ListDirectoryRegistrationsRequest)((Object)ListDirectoryRegistrationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

