/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pcaconnectorad.model.ApplicationPolicy;
import software.amazon.awssdk.services.pcaconnectorad.model.ApplicationPolicyListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationPolicies
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationPolicies> {
    private static final SdkField<Boolean> CRITICAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Critical").getter(ApplicationPolicies.getter(ApplicationPolicies::critical)).setter(ApplicationPolicies.setter(Builder::critical)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Critical").build()}).build();
    private static final SdkField<List<ApplicationPolicy>> POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Policies").getter(ApplicationPolicies.getter(ApplicationPolicies::policies)).setter(ApplicationPolicies.setter(Builder::policies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ApplicationPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRITICAL_FIELD, POLICIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Critical", CRITICAL_FIELD);
            this.put("Policies", POLICIES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Boolean critical;
    private final List<ApplicationPolicy> policies;

    private ApplicationPolicies(BuilderImpl builder) {
        this.critical = builder.critical;
        this.policies = builder.policies;
    }

    public final Boolean critical() {
        return this.critical;
    }

    public final boolean hasPolicies() {
        return this.policies != null && !(this.policies instanceof SdkAutoConstructList);
    }

    public final List<ApplicationPolicy> policies() {
        return this.policies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.critical());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicies() ? this.policies() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationPolicies)) {
            return false;
        }
        ApplicationPolicies other = (ApplicationPolicies)obj;
        return Objects.equals(this.critical(), other.critical()) && this.hasPolicies() == other.hasPolicies() && Objects.equals(this.policies(), other.policies());
    }

    public final String toString() {
        return ToString.builder((String)"ApplicationPolicies").add("Critical", (Object)this.critical()).add("Policies", this.hasPolicies() ? this.policies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Critical": {
                return Optional.ofNullable(clazz.cast(this.critical()));
            }
            case "Policies": {
                return Optional.ofNullable(clazz.cast(this.policies()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationPolicies, T> g) {
        return obj -> g.apply((ApplicationPolicies)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean critical;
        private List<ApplicationPolicy> policies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationPolicies model) {
            this.critical(model.critical);
            this.policies(model.policies);
        }

        public final Boolean getCritical() {
            return this.critical;
        }

        public final void setCritical(Boolean critical) {
            this.critical = critical;
        }

        @Override
        public final Builder critical(Boolean critical) {
            this.critical = critical;
            return this;
        }

        public final List<ApplicationPolicy.Builder> getPolicies() {
            List<ApplicationPolicy.Builder> result = ApplicationPolicyListCopier.copyToBuilder(this.policies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicies(Collection<ApplicationPolicy.BuilderImpl> policies) {
            this.policies = ApplicationPolicyListCopier.copyFromBuilder(policies);
        }

        @Override
        public final Builder policies(Collection<ApplicationPolicy> policies) {
            this.policies = ApplicationPolicyListCopier.copy(policies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(ApplicationPolicy ... policies) {
            this.policies(Arrays.asList(policies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(Consumer<ApplicationPolicy.Builder> ... policies) {
            this.policies(Stream.of(policies).map(c -> (ApplicationPolicy)((ApplicationPolicy.Builder)ApplicationPolicy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ApplicationPolicies build() {
            return new ApplicationPolicies(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationPolicies> {
        public Builder critical(Boolean var1);

        public Builder policies(Collection<ApplicationPolicy> var1);

        public Builder policies(ApplicationPolicy ... var1);

        public Builder policies(Consumer<ApplicationPolicy.Builder> ... var1);
    }
}

