/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pcaconnectorad.model.ClientCompatibilityV3;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PrivateKeyFlagsV3
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PrivateKeyFlagsV3> {
    private static final SdkField<String> CLIENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientVersion").getter(PrivateKeyFlagsV3.getter(PrivateKeyFlagsV3::clientVersionAsString)).setter(PrivateKeyFlagsV3.setter(Builder::clientVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientVersion").build()}).build();
    private static final SdkField<Boolean> EXPORTABLE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ExportableKey").getter(PrivateKeyFlagsV3.getter(PrivateKeyFlagsV3::exportableKey)).setter(PrivateKeyFlagsV3.setter(Builder::exportableKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportableKey").build()}).build();
    private static final SdkField<Boolean> REQUIRE_ALTERNATE_SIGNATURE_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RequireAlternateSignatureAlgorithm").getter(PrivateKeyFlagsV3.getter(PrivateKeyFlagsV3::requireAlternateSignatureAlgorithm)).setter(PrivateKeyFlagsV3.setter(Builder::requireAlternateSignatureAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireAlternateSignatureAlgorithm").build()}).build();
    private static final SdkField<Boolean> STRONG_KEY_PROTECTION_REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("StrongKeyProtectionRequired").getter(PrivateKeyFlagsV3.getter(PrivateKeyFlagsV3::strongKeyProtectionRequired)).setter(PrivateKeyFlagsV3.setter(Builder::strongKeyProtectionRequired)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StrongKeyProtectionRequired").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_VERSION_FIELD, EXPORTABLE_KEY_FIELD, REQUIRE_ALTERNATE_SIGNATURE_ALGORITHM_FIELD, STRONG_KEY_PROTECTION_REQUIRED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PrivateKeyFlagsV3.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String clientVersion;
    private final Boolean exportableKey;
    private final Boolean requireAlternateSignatureAlgorithm;
    private final Boolean strongKeyProtectionRequired;

    private PrivateKeyFlagsV3(BuilderImpl builder) {
        this.clientVersion = builder.clientVersion;
        this.exportableKey = builder.exportableKey;
        this.requireAlternateSignatureAlgorithm = builder.requireAlternateSignatureAlgorithm;
        this.strongKeyProtectionRequired = builder.strongKeyProtectionRequired;
    }

    public final ClientCompatibilityV3 clientVersion() {
        return ClientCompatibilityV3.fromValue(this.clientVersion);
    }

    public final String clientVersionAsString() {
        return this.clientVersion;
    }

    public final Boolean exportableKey() {
        return this.exportableKey;
    }

    public final Boolean requireAlternateSignatureAlgorithm() {
        return this.requireAlternateSignatureAlgorithm;
    }

    public final Boolean strongKeyProtectionRequired() {
        return this.strongKeyProtectionRequired;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportableKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.requireAlternateSignatureAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(this.strongKeyProtectionRequired());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrivateKeyFlagsV3)) {
            return false;
        }
        PrivateKeyFlagsV3 other = (PrivateKeyFlagsV3)obj;
        return Objects.equals(this.clientVersionAsString(), other.clientVersionAsString()) && Objects.equals(this.exportableKey(), other.exportableKey()) && Objects.equals(this.requireAlternateSignatureAlgorithm(), other.requireAlternateSignatureAlgorithm()) && Objects.equals(this.strongKeyProtectionRequired(), other.strongKeyProtectionRequired());
    }

    public final String toString() {
        return ToString.builder((String)"PrivateKeyFlagsV3").add("ClientVersion", (Object)this.clientVersionAsString()).add("ExportableKey", (Object)this.exportableKey()).add("RequireAlternateSignatureAlgorithm", (Object)this.requireAlternateSignatureAlgorithm()).add("StrongKeyProtectionRequired", (Object)this.strongKeyProtectionRequired()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientVersion": {
                return Optional.ofNullable(clazz.cast(this.clientVersionAsString()));
            }
            case "ExportableKey": {
                return Optional.ofNullable(clazz.cast(this.exportableKey()));
            }
            case "RequireAlternateSignatureAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.requireAlternateSignatureAlgorithm()));
            }
            case "StrongKeyProtectionRequired": {
                return Optional.ofNullable(clazz.cast(this.strongKeyProtectionRequired()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClientVersion", CLIENT_VERSION_FIELD);
        map.put("ExportableKey", EXPORTABLE_KEY_FIELD);
        map.put("RequireAlternateSignatureAlgorithm", REQUIRE_ALTERNATE_SIGNATURE_ALGORITHM_FIELD);
        map.put("StrongKeyProtectionRequired", STRONG_KEY_PROTECTION_REQUIRED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PrivateKeyFlagsV3, T> g) {
        return obj -> g.apply((PrivateKeyFlagsV3)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clientVersion;
        private Boolean exportableKey;
        private Boolean requireAlternateSignatureAlgorithm;
        private Boolean strongKeyProtectionRequired;

        private BuilderImpl() {
        }

        private BuilderImpl(PrivateKeyFlagsV3 model) {
            this.clientVersion(model.clientVersion);
            this.exportableKey(model.exportableKey);
            this.requireAlternateSignatureAlgorithm(model.requireAlternateSignatureAlgorithm);
            this.strongKeyProtectionRequired(model.strongKeyProtectionRequired);
        }

        public final String getClientVersion() {
            return this.clientVersion;
        }

        public final void setClientVersion(String clientVersion) {
            this.clientVersion = clientVersion;
        }

        @Override
        public final Builder clientVersion(String clientVersion) {
            this.clientVersion = clientVersion;
            return this;
        }

        @Override
        public final Builder clientVersion(ClientCompatibilityV3 clientVersion) {
            this.clientVersion(clientVersion == null ? null : clientVersion.toString());
            return this;
        }

        public final Boolean getExportableKey() {
            return this.exportableKey;
        }

        public final void setExportableKey(Boolean exportableKey) {
            this.exportableKey = exportableKey;
        }

        @Override
        public final Builder exportableKey(Boolean exportableKey) {
            this.exportableKey = exportableKey;
            return this;
        }

        public final Boolean getRequireAlternateSignatureAlgorithm() {
            return this.requireAlternateSignatureAlgorithm;
        }

        public final void setRequireAlternateSignatureAlgorithm(Boolean requireAlternateSignatureAlgorithm) {
            this.requireAlternateSignatureAlgorithm = requireAlternateSignatureAlgorithm;
        }

        @Override
        public final Builder requireAlternateSignatureAlgorithm(Boolean requireAlternateSignatureAlgorithm) {
            this.requireAlternateSignatureAlgorithm = requireAlternateSignatureAlgorithm;
            return this;
        }

        public final Boolean getStrongKeyProtectionRequired() {
            return this.strongKeyProtectionRequired;
        }

        public final void setStrongKeyProtectionRequired(Boolean strongKeyProtectionRequired) {
            this.strongKeyProtectionRequired = strongKeyProtectionRequired;
        }

        @Override
        public final Builder strongKeyProtectionRequired(Boolean strongKeyProtectionRequired) {
            this.strongKeyProtectionRequired = strongKeyProtectionRequired;
            return this;
        }

        public PrivateKeyFlagsV3 build() {
            return new PrivateKeyFlagsV3(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PrivateKeyFlagsV3> {
        public Builder clientVersion(String var1);

        public Builder clientVersion(ClientCompatibilityV3 var1);

        public Builder exportableKey(Boolean var1);

        public Builder requireAlternateSignatureAlgorithm(Boolean var1);

        public Builder strongKeyProtectionRequired(Boolean var1);
    }
}

