/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pcaconnectorad.model.AccessRight;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccessRights
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccessRights> {
    private static final SdkField<String> AUTO_ENROLL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoEnroll").getter(AccessRights.getter(AccessRights::autoEnrollAsString)).setter(AccessRights.setter(Builder::autoEnroll)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoEnroll").build()}).build();
    private static final SdkField<String> ENROLL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Enroll").getter(AccessRights.getter(AccessRights::enrollAsString)).setter(AccessRights.setter(Builder::enroll)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enroll").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ENROLL_FIELD, ENROLL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AutoEnroll", AUTO_ENROLL_FIELD);
            this.put("Enroll", ENROLL_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String autoEnroll;
    private final String enroll;

    private AccessRights(BuilderImpl builder) {
        this.autoEnroll = builder.autoEnroll;
        this.enroll = builder.enroll;
    }

    public final AccessRight autoEnroll() {
        return AccessRight.fromValue(this.autoEnroll);
    }

    public final String autoEnrollAsString() {
        return this.autoEnroll;
    }

    public final AccessRight enroll() {
        return AccessRight.fromValue(this.enroll);
    }

    public final String enrollAsString() {
        return this.enroll;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoEnrollAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enrollAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessRights)) {
            return false;
        }
        AccessRights other = (AccessRights)obj;
        return Objects.equals(this.autoEnrollAsString(), other.autoEnrollAsString()) && Objects.equals(this.enrollAsString(), other.enrollAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AccessRights").add("AutoEnroll", (Object)this.autoEnrollAsString()).add("Enroll", (Object)this.enrollAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoEnroll": {
                return Optional.ofNullable(clazz.cast(this.autoEnrollAsString()));
            }
            case "Enroll": {
                return Optional.ofNullable(clazz.cast(this.enrollAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AccessRights, T> g) {
        return obj -> g.apply((AccessRights)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String autoEnroll;
        private String enroll;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessRights model) {
            this.autoEnroll(model.autoEnroll);
            this.enroll(model.enroll);
        }

        public final String getAutoEnroll() {
            return this.autoEnroll;
        }

        public final void setAutoEnroll(String autoEnroll) {
            this.autoEnroll = autoEnroll;
        }

        @Override
        public final Builder autoEnroll(String autoEnroll) {
            this.autoEnroll = autoEnroll;
            return this;
        }

        @Override
        public final Builder autoEnroll(AccessRight autoEnroll) {
            this.autoEnroll(autoEnroll == null ? null : autoEnroll.toString());
            return this;
        }

        public final String getEnroll() {
            return this.enroll;
        }

        public final void setEnroll(String enroll) {
            this.enroll = enroll;
        }

        @Override
        public final Builder enroll(String enroll) {
            this.enroll = enroll;
            return this;
        }

        @Override
        public final Builder enroll(AccessRight enroll) {
            this.enroll(enroll == null ? null : enroll.toString());
            return this;
        }

        public AccessRights build() {
            return new AccessRights(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccessRights> {
        public Builder autoEnroll(String var1);

        public Builder autoEnroll(AccessRight var1);

        public Builder enroll(String var1);

        public Builder enroll(AccessRight var1);
    }
}

