/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorad.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pcaconnectorad.PcaConnectorAdAsyncClient;
import software.amazon.awssdk.services.pcaconnectorad.internal.UserAgentUtils;
import software.amazon.awssdk.services.pcaconnectorad.model.ListServicePrincipalNamesRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.ListServicePrincipalNamesResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.ServicePrincipalNameSummary;

public class ListServicePrincipalNamesPublisher
implements SdkPublisher<ListServicePrincipalNamesResponse> {
    private final PcaConnectorAdAsyncClient client;
    private final ListServicePrincipalNamesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListServicePrincipalNamesPublisher(PcaConnectorAdAsyncClient client, ListServicePrincipalNamesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListServicePrincipalNamesPublisher(PcaConnectorAdAsyncClient client, ListServicePrincipalNamesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListServicePrincipalNamesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListServicePrincipalNamesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ServicePrincipalNameSummary> servicePrincipalNames() {
        Function<ListServicePrincipalNamesResponse, Iterator> getIterator = response -> {
            if (response != null && response.servicePrincipalNames() != null) {
                return response.servicePrincipalNames().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListServicePrincipalNamesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListServicePrincipalNamesResponseFetcher
    implements AsyncPageFetcher<ListServicePrincipalNamesResponse> {
        private ListServicePrincipalNamesResponseFetcher() {
        }

        public boolean hasNextPage(ListServicePrincipalNamesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListServicePrincipalNamesResponse> nextPage(ListServicePrincipalNamesResponse previousPage) {
            if (previousPage == null) {
                return ListServicePrincipalNamesPublisher.this.client.listServicePrincipalNames(ListServicePrincipalNamesPublisher.this.firstRequest);
            }
            return ListServicePrincipalNamesPublisher.this.client.listServicePrincipalNames((ListServicePrincipalNamesRequest)((Object)ListServicePrincipalNamesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

