/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorad.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pcaconnectorad.PcaConnectorAdClient;
import software.amazon.awssdk.services.pcaconnectorad.internal.UserAgentUtils;
import software.amazon.awssdk.services.pcaconnectorad.model.AccessControlEntrySummary;
import software.amazon.awssdk.services.pcaconnectorad.model.ListTemplateGroupAccessControlEntriesRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.ListTemplateGroupAccessControlEntriesResponse;

public class ListTemplateGroupAccessControlEntriesIterable
implements SdkIterable<ListTemplateGroupAccessControlEntriesResponse> {
    private final PcaConnectorAdClient client;
    private final ListTemplateGroupAccessControlEntriesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTemplateGroupAccessControlEntriesIterable(PcaConnectorAdClient client, ListTemplateGroupAccessControlEntriesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTemplateGroupAccessControlEntriesResponseFetcher();
    }

    public Iterator<ListTemplateGroupAccessControlEntriesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AccessControlEntrySummary> accessControlEntries() {
        Function<ListTemplateGroupAccessControlEntriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.accessControlEntries() != null) {
                return response.accessControlEntries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTemplateGroupAccessControlEntriesResponseFetcher
    implements SyncPageFetcher<ListTemplateGroupAccessControlEntriesResponse> {
        private ListTemplateGroupAccessControlEntriesResponseFetcher() {
        }

        public boolean hasNextPage(ListTemplateGroupAccessControlEntriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTemplateGroupAccessControlEntriesResponse nextPage(ListTemplateGroupAccessControlEntriesResponse previousPage) {
            if (previousPage == null) {
                return ListTemplateGroupAccessControlEntriesIterable.this.client.listTemplateGroupAccessControlEntries(ListTemplateGroupAccessControlEntriesIterable.this.firstRequest);
            }
            return ListTemplateGroupAccessControlEntriesIterable.this.client.listTemplateGroupAccessControlEntries((ListTemplateGroupAccessControlEntriesRequest)((Object)ListTemplateGroupAccessControlEntriesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

