/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorad.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PrivateKeyAlgorithm {
    RSA("RSA"),
    ECDH_P256("ECDH_P256"),
    ECDH_P384("ECDH_P384"),
    ECDH_P521("ECDH_P521"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PrivateKeyAlgorithm> VALUE_MAP;
    private final String value;

    private PrivateKeyAlgorithm(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PrivateKeyAlgorithm fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PrivateKeyAlgorithm> knownValues() {
        EnumSet<PrivateKeyAlgorithm> knownValues = EnumSet.allOf(PrivateKeyAlgorithm.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PrivateKeyAlgorithm.class, PrivateKeyAlgorithm::toString);
    }
}

