/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorad.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ClientCompatibilityV2 {
    WINDOWS_SERVER_2003("WINDOWS_SERVER_2003"),
    WINDOWS_SERVER_2008("WINDOWS_SERVER_2008"),
    WINDOWS_SERVER_2008_R2("WINDOWS_SERVER_2008_R2"),
    WINDOWS_SERVER_2012("WINDOWS_SERVER_2012"),
    WINDOWS_SERVER_2012_R2("WINDOWS_SERVER_2012_R2"),
    WINDOWS_SERVER_2016("WINDOWS_SERVER_2016"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ClientCompatibilityV2> VALUE_MAP;
    private final String value;

    private ClientCompatibilityV2(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ClientCompatibilityV2 fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ClientCompatibilityV2> knownValues() {
        EnumSet<ClientCompatibilityV2> knownValues = EnumSet.allOf(ClientCompatibilityV2.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ClientCompatibilityV2.class, ClientCompatibilityV2::toString);
    }
}

