/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorad;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.pcaconnectorad.DefaultPcaConnectorAdBaseClientBuilder;
import software.amazon.awssdk.services.pcaconnectorad.DefaultPcaConnectorAdClient;
import software.amazon.awssdk.services.pcaconnectorad.PcaConnectorAdClient;
import software.amazon.awssdk.services.pcaconnectorad.PcaConnectorAdClientBuilder;
import software.amazon.awssdk.services.pcaconnectorad.PcaConnectorAdServiceClientConfiguration;
import software.amazon.awssdk.services.pcaconnectorad.endpoints.PcaConnectorAdEndpointProvider;

@SdkInternalApi
final class DefaultPcaConnectorAdClientBuilder
extends DefaultPcaConnectorAdBaseClientBuilder<PcaConnectorAdClientBuilder, PcaConnectorAdClient>
implements PcaConnectorAdClientBuilder {
    DefaultPcaConnectorAdClientBuilder() {
    }

    @Override
    public DefaultPcaConnectorAdClientBuilder endpointProvider(PcaConnectorAdEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final PcaConnectorAdClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultPcaConnectorAdClientBuilder.validateClientOptions(clientConfiguration);
        PcaConnectorAdServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultPcaConnectorAdClient client = new DefaultPcaConnectorAdClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private PcaConnectorAdServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return PcaConnectorAdServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

