/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.paymentcryptographydata.DefaultPaymentCryptographyDataAsyncClientBuilder;
import software.amazon.awssdk.services.paymentcryptographydata.PaymentCryptographyDataAsyncClientBuilder;
import software.amazon.awssdk.services.paymentcryptographydata.PaymentCryptographyDataServiceClientConfiguration;
import software.amazon.awssdk.services.paymentcryptographydata.model.DecryptDataRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.DecryptDataResponse;
import software.amazon.awssdk.services.paymentcryptographydata.model.EncryptDataRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.EncryptDataResponse;
import software.amazon.awssdk.services.paymentcryptographydata.model.GenerateCardValidationDataRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.GenerateCardValidationDataResponse;
import software.amazon.awssdk.services.paymentcryptographydata.model.GenerateMacEmvPinChangeRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.GenerateMacEmvPinChangeResponse;
import software.amazon.awssdk.services.paymentcryptographydata.model.GenerateMacRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.GenerateMacResponse;
import software.amazon.awssdk.services.paymentcryptographydata.model.GeneratePinDataRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.GeneratePinDataResponse;
import software.amazon.awssdk.services.paymentcryptographydata.model.ReEncryptDataRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.ReEncryptDataResponse;
import software.amazon.awssdk.services.paymentcryptographydata.model.TranslatePinDataRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.TranslatePinDataResponse;
import software.amazon.awssdk.services.paymentcryptographydata.model.VerifyAuthRequestCryptogramRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.VerifyAuthRequestCryptogramResponse;
import software.amazon.awssdk.services.paymentcryptographydata.model.VerifyCardValidationDataRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.VerifyCardValidationDataResponse;
import software.amazon.awssdk.services.paymentcryptographydata.model.VerifyMacRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.VerifyMacResponse;
import software.amazon.awssdk.services.paymentcryptographydata.model.VerifyPinDataRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.VerifyPinDataResponse;

@SdkPublicApi
@ThreadSafe
public interface PaymentCryptographyDataAsyncClient
extends AwsClient {
    public static final String SERVICE_NAME = "payment-cryptography";
    public static final String SERVICE_METADATA_ID = "dataplane.payment-cryptography";

    default public CompletableFuture<DecryptDataResponse> decryptData(DecryptDataRequest decryptDataRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DecryptDataResponse> decryptData(Consumer<DecryptDataRequest.Builder> decryptDataRequest) {
        return this.decryptData((DecryptDataRequest)((Object)((DecryptDataRequest.Builder)DecryptDataRequest.builder().applyMutation(decryptDataRequest)).build()));
    }

    default public CompletableFuture<EncryptDataResponse> encryptData(EncryptDataRequest encryptDataRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<EncryptDataResponse> encryptData(Consumer<EncryptDataRequest.Builder> encryptDataRequest) {
        return this.encryptData((EncryptDataRequest)((Object)((EncryptDataRequest.Builder)EncryptDataRequest.builder().applyMutation(encryptDataRequest)).build()));
    }

    default public CompletableFuture<GenerateCardValidationDataResponse> generateCardValidationData(GenerateCardValidationDataRequest generateCardValidationDataRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GenerateCardValidationDataResponse> generateCardValidationData(Consumer<GenerateCardValidationDataRequest.Builder> generateCardValidationDataRequest) {
        return this.generateCardValidationData((GenerateCardValidationDataRequest)((Object)((GenerateCardValidationDataRequest.Builder)GenerateCardValidationDataRequest.builder().applyMutation(generateCardValidationDataRequest)).build()));
    }

    default public CompletableFuture<GenerateMacResponse> generateMac(GenerateMacRequest generateMacRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GenerateMacResponse> generateMac(Consumer<GenerateMacRequest.Builder> generateMacRequest) {
        return this.generateMac((GenerateMacRequest)((Object)((GenerateMacRequest.Builder)GenerateMacRequest.builder().applyMutation(generateMacRequest)).build()));
    }

    default public CompletableFuture<GenerateMacEmvPinChangeResponse> generateMacEmvPinChange(GenerateMacEmvPinChangeRequest generateMacEmvPinChangeRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GenerateMacEmvPinChangeResponse> generateMacEmvPinChange(Consumer<GenerateMacEmvPinChangeRequest.Builder> generateMacEmvPinChangeRequest) {
        return this.generateMacEmvPinChange((GenerateMacEmvPinChangeRequest)((Object)((GenerateMacEmvPinChangeRequest.Builder)GenerateMacEmvPinChangeRequest.builder().applyMutation(generateMacEmvPinChangeRequest)).build()));
    }

    default public CompletableFuture<GeneratePinDataResponse> generatePinData(GeneratePinDataRequest generatePinDataRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GeneratePinDataResponse> generatePinData(Consumer<GeneratePinDataRequest.Builder> generatePinDataRequest) {
        return this.generatePinData((GeneratePinDataRequest)((Object)((GeneratePinDataRequest.Builder)GeneratePinDataRequest.builder().applyMutation(generatePinDataRequest)).build()));
    }

    default public CompletableFuture<ReEncryptDataResponse> reEncryptData(ReEncryptDataRequest reEncryptDataRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ReEncryptDataResponse> reEncryptData(Consumer<ReEncryptDataRequest.Builder> reEncryptDataRequest) {
        return this.reEncryptData((ReEncryptDataRequest)((Object)((ReEncryptDataRequest.Builder)ReEncryptDataRequest.builder().applyMutation(reEncryptDataRequest)).build()));
    }

    default public CompletableFuture<TranslatePinDataResponse> translatePinData(TranslatePinDataRequest translatePinDataRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<TranslatePinDataResponse> translatePinData(Consumer<TranslatePinDataRequest.Builder> translatePinDataRequest) {
        return this.translatePinData((TranslatePinDataRequest)((Object)((TranslatePinDataRequest.Builder)TranslatePinDataRequest.builder().applyMutation(translatePinDataRequest)).build()));
    }

    default public CompletableFuture<VerifyAuthRequestCryptogramResponse> verifyAuthRequestCryptogram(VerifyAuthRequestCryptogramRequest verifyAuthRequestCryptogramRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<VerifyAuthRequestCryptogramResponse> verifyAuthRequestCryptogram(Consumer<VerifyAuthRequestCryptogramRequest.Builder> verifyAuthRequestCryptogramRequest) {
        return this.verifyAuthRequestCryptogram((VerifyAuthRequestCryptogramRequest)((Object)((VerifyAuthRequestCryptogramRequest.Builder)VerifyAuthRequestCryptogramRequest.builder().applyMutation(verifyAuthRequestCryptogramRequest)).build()));
    }

    default public CompletableFuture<VerifyCardValidationDataResponse> verifyCardValidationData(VerifyCardValidationDataRequest verifyCardValidationDataRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<VerifyCardValidationDataResponse> verifyCardValidationData(Consumer<VerifyCardValidationDataRequest.Builder> verifyCardValidationDataRequest) {
        return this.verifyCardValidationData((VerifyCardValidationDataRequest)((Object)((VerifyCardValidationDataRequest.Builder)VerifyCardValidationDataRequest.builder().applyMutation(verifyCardValidationDataRequest)).build()));
    }

    default public CompletableFuture<VerifyMacResponse> verifyMac(VerifyMacRequest verifyMacRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<VerifyMacResponse> verifyMac(Consumer<VerifyMacRequest.Builder> verifyMacRequest) {
        return this.verifyMac((VerifyMacRequest)((Object)((VerifyMacRequest.Builder)VerifyMacRequest.builder().applyMutation(verifyMacRequest)).build()));
    }

    default public CompletableFuture<VerifyPinDataResponse> verifyPinData(VerifyPinDataRequest verifyPinDataRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<VerifyPinDataResponse> verifyPinData(Consumer<VerifyPinDataRequest.Builder> verifyPinDataRequest) {
        return this.verifyPinData((VerifyPinDataRequest)((Object)((VerifyPinDataRequest.Builder)VerifyPinDataRequest.builder().applyMutation(verifyPinDataRequest)).build()));
    }

    default public PaymentCryptographyDataServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    public static PaymentCryptographyDataAsyncClient create() {
        return (PaymentCryptographyDataAsyncClient)PaymentCryptographyDataAsyncClient.builder().build();
    }

    public static PaymentCryptographyDataAsyncClientBuilder builder() {
        return new DefaultPaymentCryptographyDataAsyncClientBuilder();
    }
}

