/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptographydata.model.MacAttributes;
import software.amazon.awssdk.services.paymentcryptographydata.model.PaymentCryptographyDataRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GenerateMacRequest
extends PaymentCryptographyDataRequest
implements ToCopyableBuilder<Builder, GenerateMacRequest> {
    private static final SdkField<String> KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyIdentifier").getter(GenerateMacRequest.getter(GenerateMacRequest::keyIdentifier)).setter(GenerateMacRequest.setter(Builder::keyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyIdentifier").build()}).build();
    private static final SdkField<String> MESSAGE_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageData").getter(GenerateMacRequest.getter(GenerateMacRequest::messageData)).setter(GenerateMacRequest.setter(Builder::messageData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageData").build()}).build();
    private static final SdkField<MacAttributes> GENERATION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GenerationAttributes").getter(GenerateMacRequest.getter(GenerateMacRequest::generationAttributes)).setter(GenerateMacRequest.setter(Builder::generationAttributes)).constructor(MacAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerationAttributes").build()}).build();
    private static final SdkField<Integer> MAC_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MacLength").getter(GenerateMacRequest.getter(GenerateMacRequest::macLength)).setter(GenerateMacRequest.setter(Builder::macLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MacLength").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_IDENTIFIER_FIELD, MESSAGE_DATA_FIELD, GENERATION_ATTRIBUTES_FIELD, MAC_LENGTH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("KeyIdentifier", KEY_IDENTIFIER_FIELD);
            this.put("MessageData", MESSAGE_DATA_FIELD);
            this.put("GenerationAttributes", GENERATION_ATTRIBUTES_FIELD);
            this.put("MacLength", MAC_LENGTH_FIELD);
        }
    });
    private final String keyIdentifier;
    private final String messageData;
    private final MacAttributes generationAttributes;
    private final Integer macLength;

    private GenerateMacRequest(BuilderImpl builder) {
        super(builder);
        this.keyIdentifier = builder.keyIdentifier;
        this.messageData = builder.messageData;
        this.generationAttributes = builder.generationAttributes;
        this.macLength = builder.macLength;
    }

    public final String keyIdentifier() {
        return this.keyIdentifier;
    }

    public final String messageData() {
        return this.messageData;
    }

    public final MacAttributes generationAttributes() {
        return this.generationAttributes;
    }

    public final Integer macLength() {
        return this.macLength;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageData());
        hashCode = 31 * hashCode + Objects.hashCode(this.generationAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.macLength());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateMacRequest)) {
            return false;
        }
        GenerateMacRequest other = (GenerateMacRequest)((Object)obj);
        return Objects.equals(this.keyIdentifier(), other.keyIdentifier()) && Objects.equals(this.messageData(), other.messageData()) && Objects.equals(this.generationAttributes(), other.generationAttributes()) && Objects.equals(this.macLength(), other.macLength());
    }

    public final String toString() {
        return ToString.builder((String)"GenerateMacRequest").add("KeyIdentifier", (Object)this.keyIdentifier()).add("MessageData", (Object)(this.messageData() == null ? null : "*** Sensitive Data Redacted ***")).add("GenerationAttributes", (Object)this.generationAttributes()).add("MacLength", (Object)this.macLength()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.keyIdentifier()));
            }
            case "MessageData": {
                return Optional.ofNullable(clazz.cast(this.messageData()));
            }
            case "GenerationAttributes": {
                return Optional.ofNullable(clazz.cast(this.generationAttributes()));
            }
            case "MacLength": {
                return Optional.ofNullable(clazz.cast(this.macLength()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GenerateMacRequest, T> g) {
        return obj -> g.apply((GenerateMacRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PaymentCryptographyDataRequest.BuilderImpl
    implements Builder {
        private String keyIdentifier;
        private String messageData;
        private MacAttributes generationAttributes;
        private Integer macLength;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateMacRequest model) {
            super(model);
            this.keyIdentifier(model.keyIdentifier);
            this.messageData(model.messageData);
            this.generationAttributes(model.generationAttributes);
            this.macLength(model.macLength);
        }

        public final String getKeyIdentifier() {
            return this.keyIdentifier;
        }

        public final void setKeyIdentifier(String keyIdentifier) {
            this.keyIdentifier = keyIdentifier;
        }

        @Override
        public final Builder keyIdentifier(String keyIdentifier) {
            this.keyIdentifier = keyIdentifier;
            return this;
        }

        public final String getMessageData() {
            return this.messageData;
        }

        public final void setMessageData(String messageData) {
            this.messageData = messageData;
        }

        @Override
        public final Builder messageData(String messageData) {
            this.messageData = messageData;
            return this;
        }

        public final MacAttributes.Builder getGenerationAttributes() {
            return this.generationAttributes != null ? this.generationAttributes.toBuilder() : null;
        }

        public final void setGenerationAttributes(MacAttributes.BuilderImpl generationAttributes) {
            this.generationAttributes = generationAttributes != null ? generationAttributes.build() : null;
        }

        @Override
        public final Builder generationAttributes(MacAttributes generationAttributes) {
            this.generationAttributes = generationAttributes;
            return this;
        }

        public final Integer getMacLength() {
            return this.macLength;
        }

        public final void setMacLength(Integer macLength) {
            this.macLength = macLength;
        }

        @Override
        public final Builder macLength(Integer macLength) {
            this.macLength = macLength;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GenerateMacRequest build() {
            return new GenerateMacRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PaymentCryptographyDataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GenerateMacRequest> {
        public Builder keyIdentifier(String var1);

        public Builder messageData(String var1);

        public Builder generationAttributes(MacAttributes var1);

        default public Builder generationAttributes(Consumer<MacAttributes.Builder> generationAttributes) {
            return this.generationAttributes((MacAttributes)((MacAttributes.Builder)MacAttributes.builder().applyMutation(generationAttributes)).build());
        }

        public Builder macLength(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

