/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Ibm3624PinOffset
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Ibm3624PinOffset> {
    private static final SdkField<String> ENCRYPTED_PIN_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptedPinBlock").getter(Ibm3624PinOffset.getter(Ibm3624PinOffset::encryptedPinBlock)).setter(Ibm3624PinOffset.setter(Builder::encryptedPinBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptedPinBlock").build()}).build();
    private static final SdkField<String> DECIMALIZATION_TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DecimalizationTable").getter(Ibm3624PinOffset.getter(Ibm3624PinOffset::decimalizationTable)).setter(Ibm3624PinOffset.setter(Builder::decimalizationTable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DecimalizationTable").build()}).build();
    private static final SdkField<String> PIN_VALIDATION_DATA_PAD_CHARACTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PinValidationDataPadCharacter").getter(Ibm3624PinOffset.getter(Ibm3624PinOffset::pinValidationDataPadCharacter)).setter(Ibm3624PinOffset.setter(Builder::pinValidationDataPadCharacter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PinValidationDataPadCharacter").build()}).build();
    private static final SdkField<String> PIN_VALIDATION_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PinValidationData").getter(Ibm3624PinOffset.getter(Ibm3624PinOffset::pinValidationData)).setter(Ibm3624PinOffset.setter(Builder::pinValidationData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PinValidationData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTED_PIN_BLOCK_FIELD, DECIMALIZATION_TABLE_FIELD, PIN_VALIDATION_DATA_PAD_CHARACTER_FIELD, PIN_VALIDATION_DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("EncryptedPinBlock", ENCRYPTED_PIN_BLOCK_FIELD);
            this.put("DecimalizationTable", DECIMALIZATION_TABLE_FIELD);
            this.put("PinValidationDataPadCharacter", PIN_VALIDATION_DATA_PAD_CHARACTER_FIELD);
            this.put("PinValidationData", PIN_VALIDATION_DATA_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String encryptedPinBlock;
    private final String decimalizationTable;
    private final String pinValidationDataPadCharacter;
    private final String pinValidationData;

    private Ibm3624PinOffset(BuilderImpl builder) {
        this.encryptedPinBlock = builder.encryptedPinBlock;
        this.decimalizationTable = builder.decimalizationTable;
        this.pinValidationDataPadCharacter = builder.pinValidationDataPadCharacter;
        this.pinValidationData = builder.pinValidationData;
    }

    public final String encryptedPinBlock() {
        return this.encryptedPinBlock;
    }

    public final String decimalizationTable() {
        return this.decimalizationTable;
    }

    public final String pinValidationDataPadCharacter() {
        return this.pinValidationDataPadCharacter;
    }

    public final String pinValidationData() {
        return this.pinValidationData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptedPinBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.decimalizationTable());
        hashCode = 31 * hashCode + Objects.hashCode(this.pinValidationDataPadCharacter());
        hashCode = 31 * hashCode + Objects.hashCode(this.pinValidationData());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ibm3624PinOffset)) {
            return false;
        }
        Ibm3624PinOffset other = (Ibm3624PinOffset)obj;
        return Objects.equals(this.encryptedPinBlock(), other.encryptedPinBlock()) && Objects.equals(this.decimalizationTable(), other.decimalizationTable()) && Objects.equals(this.pinValidationDataPadCharacter(), other.pinValidationDataPadCharacter()) && Objects.equals(this.pinValidationData(), other.pinValidationData());
    }

    public final String toString() {
        return ToString.builder((String)"Ibm3624PinOffset").add("EncryptedPinBlock", (Object)(this.encryptedPinBlock() == null ? null : "*** Sensitive Data Redacted ***")).add("DecimalizationTable", (Object)(this.decimalizationTable() == null ? null : "*** Sensitive Data Redacted ***")).add("PinValidationDataPadCharacter", (Object)this.pinValidationDataPadCharacter()).add("PinValidationData", (Object)(this.pinValidationData() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EncryptedPinBlock": {
                return Optional.ofNullable(clazz.cast(this.encryptedPinBlock()));
            }
            case "DecimalizationTable": {
                return Optional.ofNullable(clazz.cast(this.decimalizationTable()));
            }
            case "PinValidationDataPadCharacter": {
                return Optional.ofNullable(clazz.cast(this.pinValidationDataPadCharacter()));
            }
            case "PinValidationData": {
                return Optional.ofNullable(clazz.cast(this.pinValidationData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Ibm3624PinOffset, T> g) {
        return obj -> g.apply((Ibm3624PinOffset)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String encryptedPinBlock;
        private String decimalizationTable;
        private String pinValidationDataPadCharacter;
        private String pinValidationData;

        private BuilderImpl() {
        }

        private BuilderImpl(Ibm3624PinOffset model) {
            this.encryptedPinBlock(model.encryptedPinBlock);
            this.decimalizationTable(model.decimalizationTable);
            this.pinValidationDataPadCharacter(model.pinValidationDataPadCharacter);
            this.pinValidationData(model.pinValidationData);
        }

        public final String getEncryptedPinBlock() {
            return this.encryptedPinBlock;
        }

        public final void setEncryptedPinBlock(String encryptedPinBlock) {
            this.encryptedPinBlock = encryptedPinBlock;
        }

        @Override
        public final Builder encryptedPinBlock(String encryptedPinBlock) {
            this.encryptedPinBlock = encryptedPinBlock;
            return this;
        }

        public final String getDecimalizationTable() {
            return this.decimalizationTable;
        }

        public final void setDecimalizationTable(String decimalizationTable) {
            this.decimalizationTable = decimalizationTable;
        }

        @Override
        public final Builder decimalizationTable(String decimalizationTable) {
            this.decimalizationTable = decimalizationTable;
            return this;
        }

        public final String getPinValidationDataPadCharacter() {
            return this.pinValidationDataPadCharacter;
        }

        public final void setPinValidationDataPadCharacter(String pinValidationDataPadCharacter) {
            this.pinValidationDataPadCharacter = pinValidationDataPadCharacter;
        }

        @Override
        public final Builder pinValidationDataPadCharacter(String pinValidationDataPadCharacter) {
            this.pinValidationDataPadCharacter = pinValidationDataPadCharacter;
            return this;
        }

        public final String getPinValidationData() {
            return this.pinValidationData;
        }

        public final void setPinValidationData(String pinValidationData) {
            this.pinValidationData = pinValidationData;
        }

        @Override
        public final Builder pinValidationData(String pinValidationData) {
            this.pinValidationData = pinValidationData;
            return this;
        }

        public Ibm3624PinOffset build() {
            return new Ibm3624PinOffset(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Ibm3624PinOffset> {
        public Builder encryptedPinBlock(String var1);

        public Builder decimalizationTable(String var1);

        public Builder pinValidationDataPadCharacter(String var1);

        public Builder pinValidationData(String var1);
    }
}

