/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptographydata.model.MajorKeyDerivationMode;
import software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyDerivationMode;
import software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyDerivationValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MacAlgorithmEmv
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MacAlgorithmEmv> {
    private static final SdkField<String> MAJOR_KEY_DERIVATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MajorKeyDerivationMode").getter(MacAlgorithmEmv.getter(MacAlgorithmEmv::majorKeyDerivationModeAsString)).setter(MacAlgorithmEmv.setter(Builder::majorKeyDerivationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MajorKeyDerivationMode").build()}).build();
    private static final SdkField<String> PRIMARY_ACCOUNT_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryAccountNumber").getter(MacAlgorithmEmv.getter(MacAlgorithmEmv::primaryAccountNumber)).setter(MacAlgorithmEmv.setter(Builder::primaryAccountNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryAccountNumber").build()}).build();
    private static final SdkField<String> PAN_SEQUENCE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PanSequenceNumber").getter(MacAlgorithmEmv.getter(MacAlgorithmEmv::panSequenceNumber)).setter(MacAlgorithmEmv.setter(Builder::panSequenceNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PanSequenceNumber").build()}).build();
    private static final SdkField<String> SESSION_KEY_DERIVATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SessionKeyDerivationMode").getter(MacAlgorithmEmv.getter(MacAlgorithmEmv::sessionKeyDerivationModeAsString)).setter(MacAlgorithmEmv.setter(Builder::sessionKeyDerivationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionKeyDerivationMode").build()}).build();
    private static final SdkField<SessionKeyDerivationValue> SESSION_KEY_DERIVATION_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SessionKeyDerivationValue").getter(MacAlgorithmEmv.getter(MacAlgorithmEmv::sessionKeyDerivationValue)).setter(MacAlgorithmEmv.setter(Builder::sessionKeyDerivationValue)).constructor(SessionKeyDerivationValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionKeyDerivationValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAJOR_KEY_DERIVATION_MODE_FIELD, PRIMARY_ACCOUNT_NUMBER_FIELD, PAN_SEQUENCE_NUMBER_FIELD, SESSION_KEY_DERIVATION_MODE_FIELD, SESSION_KEY_DERIVATION_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("MajorKeyDerivationMode", MAJOR_KEY_DERIVATION_MODE_FIELD);
            this.put("PrimaryAccountNumber", PRIMARY_ACCOUNT_NUMBER_FIELD);
            this.put("PanSequenceNumber", PAN_SEQUENCE_NUMBER_FIELD);
            this.put("SessionKeyDerivationMode", SESSION_KEY_DERIVATION_MODE_FIELD);
            this.put("SessionKeyDerivationValue", SESSION_KEY_DERIVATION_VALUE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String majorKeyDerivationMode;
    private final String primaryAccountNumber;
    private final String panSequenceNumber;
    private final String sessionKeyDerivationMode;
    private final SessionKeyDerivationValue sessionKeyDerivationValue;

    private MacAlgorithmEmv(BuilderImpl builder) {
        this.majorKeyDerivationMode = builder.majorKeyDerivationMode;
        this.primaryAccountNumber = builder.primaryAccountNumber;
        this.panSequenceNumber = builder.panSequenceNumber;
        this.sessionKeyDerivationMode = builder.sessionKeyDerivationMode;
        this.sessionKeyDerivationValue = builder.sessionKeyDerivationValue;
    }

    public final MajorKeyDerivationMode majorKeyDerivationMode() {
        return MajorKeyDerivationMode.fromValue(this.majorKeyDerivationMode);
    }

    public final String majorKeyDerivationModeAsString() {
        return this.majorKeyDerivationMode;
    }

    public final String primaryAccountNumber() {
        return this.primaryAccountNumber;
    }

    public final String panSequenceNumber() {
        return this.panSequenceNumber;
    }

    public final SessionKeyDerivationMode sessionKeyDerivationMode() {
        return SessionKeyDerivationMode.fromValue(this.sessionKeyDerivationMode);
    }

    public final String sessionKeyDerivationModeAsString() {
        return this.sessionKeyDerivationMode;
    }

    public final SessionKeyDerivationValue sessionKeyDerivationValue() {
        return this.sessionKeyDerivationValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.majorKeyDerivationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryAccountNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.panSequenceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionKeyDerivationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionKeyDerivationValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MacAlgorithmEmv)) {
            return false;
        }
        MacAlgorithmEmv other = (MacAlgorithmEmv)obj;
        return Objects.equals(this.majorKeyDerivationModeAsString(), other.majorKeyDerivationModeAsString()) && Objects.equals(this.primaryAccountNumber(), other.primaryAccountNumber()) && Objects.equals(this.panSequenceNumber(), other.panSequenceNumber()) && Objects.equals(this.sessionKeyDerivationModeAsString(), other.sessionKeyDerivationModeAsString()) && Objects.equals(this.sessionKeyDerivationValue(), other.sessionKeyDerivationValue());
    }

    public final String toString() {
        return ToString.builder((String)"MacAlgorithmEmv").add("MajorKeyDerivationMode", (Object)this.majorKeyDerivationModeAsString()).add("PrimaryAccountNumber", (Object)(this.primaryAccountNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("PanSequenceNumber", (Object)this.panSequenceNumber()).add("SessionKeyDerivationMode", (Object)this.sessionKeyDerivationModeAsString()).add("SessionKeyDerivationValue", (Object)this.sessionKeyDerivationValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MajorKeyDerivationMode": {
                return Optional.ofNullable(clazz.cast(this.majorKeyDerivationModeAsString()));
            }
            case "PrimaryAccountNumber": {
                return Optional.ofNullable(clazz.cast(this.primaryAccountNumber()));
            }
            case "PanSequenceNumber": {
                return Optional.ofNullable(clazz.cast(this.panSequenceNumber()));
            }
            case "SessionKeyDerivationMode": {
                return Optional.ofNullable(clazz.cast(this.sessionKeyDerivationModeAsString()));
            }
            case "SessionKeyDerivationValue": {
                return Optional.ofNullable(clazz.cast(this.sessionKeyDerivationValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MacAlgorithmEmv, T> g) {
        return obj -> g.apply((MacAlgorithmEmv)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String majorKeyDerivationMode;
        private String primaryAccountNumber;
        private String panSequenceNumber;
        private String sessionKeyDerivationMode;
        private SessionKeyDerivationValue sessionKeyDerivationValue;

        private BuilderImpl() {
        }

        private BuilderImpl(MacAlgorithmEmv model) {
            this.majorKeyDerivationMode(model.majorKeyDerivationMode);
            this.primaryAccountNumber(model.primaryAccountNumber);
            this.panSequenceNumber(model.panSequenceNumber);
            this.sessionKeyDerivationMode(model.sessionKeyDerivationMode);
            this.sessionKeyDerivationValue(model.sessionKeyDerivationValue);
        }

        public final String getMajorKeyDerivationMode() {
            return this.majorKeyDerivationMode;
        }

        public final void setMajorKeyDerivationMode(String majorKeyDerivationMode) {
            this.majorKeyDerivationMode = majorKeyDerivationMode;
        }

        @Override
        public final Builder majorKeyDerivationMode(String majorKeyDerivationMode) {
            this.majorKeyDerivationMode = majorKeyDerivationMode;
            return this;
        }

        @Override
        public final Builder majorKeyDerivationMode(MajorKeyDerivationMode majorKeyDerivationMode) {
            this.majorKeyDerivationMode(majorKeyDerivationMode == null ? null : majorKeyDerivationMode.toString());
            return this;
        }

        public final String getPrimaryAccountNumber() {
            return this.primaryAccountNumber;
        }

        public final void setPrimaryAccountNumber(String primaryAccountNumber) {
            this.primaryAccountNumber = primaryAccountNumber;
        }

        @Override
        public final Builder primaryAccountNumber(String primaryAccountNumber) {
            this.primaryAccountNumber = primaryAccountNumber;
            return this;
        }

        public final String getPanSequenceNumber() {
            return this.panSequenceNumber;
        }

        public final void setPanSequenceNumber(String panSequenceNumber) {
            this.panSequenceNumber = panSequenceNumber;
        }

        @Override
        public final Builder panSequenceNumber(String panSequenceNumber) {
            this.panSequenceNumber = panSequenceNumber;
            return this;
        }

        public final String getSessionKeyDerivationMode() {
            return this.sessionKeyDerivationMode;
        }

        public final void setSessionKeyDerivationMode(String sessionKeyDerivationMode) {
            this.sessionKeyDerivationMode = sessionKeyDerivationMode;
        }

        @Override
        public final Builder sessionKeyDerivationMode(String sessionKeyDerivationMode) {
            this.sessionKeyDerivationMode = sessionKeyDerivationMode;
            return this;
        }

        @Override
        public final Builder sessionKeyDerivationMode(SessionKeyDerivationMode sessionKeyDerivationMode) {
            this.sessionKeyDerivationMode(sessionKeyDerivationMode == null ? null : sessionKeyDerivationMode.toString());
            return this;
        }

        public final SessionKeyDerivationValue.Builder getSessionKeyDerivationValue() {
            return this.sessionKeyDerivationValue != null ? this.sessionKeyDerivationValue.toBuilder() : null;
        }

        public final void setSessionKeyDerivationValue(SessionKeyDerivationValue.BuilderImpl sessionKeyDerivationValue) {
            this.sessionKeyDerivationValue = sessionKeyDerivationValue != null ? sessionKeyDerivationValue.build() : null;
        }

        @Override
        public final Builder sessionKeyDerivationValue(SessionKeyDerivationValue sessionKeyDerivationValue) {
            this.sessionKeyDerivationValue = sessionKeyDerivationValue;
            return this;
        }

        public MacAlgorithmEmv build() {
            return new MacAlgorithmEmv(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MacAlgorithmEmv> {
        public Builder majorKeyDerivationMode(String var1);

        public Builder majorKeyDerivationMode(MajorKeyDerivationMode var1);

        public Builder primaryAccountNumber(String var1);

        public Builder panSequenceNumber(String var1);

        public Builder sessionKeyDerivationMode(String var1);

        public Builder sessionKeyDerivationMode(SessionKeyDerivationMode var1);

        public Builder sessionKeyDerivationValue(SessionKeyDerivationValue var1);

        default public Builder sessionKeyDerivationValue(Consumer<SessionKeyDerivationValue.Builder> sessionKeyDerivationValue) {
            return this.sessionKeyDerivationValue((SessionKeyDerivationValue)((SessionKeyDerivationValue.Builder)SessionKeyDerivationValue.builder().applyMutation(sessionKeyDerivationValue)).build());
        }
    }
}

