/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.paymentcryptographydata.model.DukptEncryptionAttributes;
import software.amazon.awssdk.services.paymentcryptographydata.model.SymmetricEncryptionAttributes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReEncryptionAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReEncryptionAttributes> {
    private static final SdkField<SymmetricEncryptionAttributes> SYMMETRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Symmetric").getter(ReEncryptionAttributes.getter(ReEncryptionAttributes::symmetric)).setter(ReEncryptionAttributes.setter(Builder::symmetric)).constructor(SymmetricEncryptionAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Symmetric").build()}).build();
    private static final SdkField<DukptEncryptionAttributes> DUKPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Dukpt").getter(ReEncryptionAttributes.getter(ReEncryptionAttributes::dukpt)).setter(ReEncryptionAttributes.setter(Builder::dukpt)).constructor(DukptEncryptionAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dukpt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SYMMETRIC_FIELD, DUKPT_FIELD));
    private static final long serialVersionUID = 1L;
    private final SymmetricEncryptionAttributes symmetric;
    private final DukptEncryptionAttributes dukpt;
    private final Type type;

    private ReEncryptionAttributes(BuilderImpl builder) {
        this.symmetric = builder.symmetric;
        this.dukpt = builder.dukpt;
        this.type = builder.type;
    }

    public final SymmetricEncryptionAttributes symmetric() {
        return this.symmetric;
    }

    public final DukptEncryptionAttributes dukpt() {
        return this.dukpt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.symmetric());
        hashCode = 31 * hashCode + Objects.hashCode(this.dukpt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReEncryptionAttributes)) {
            return false;
        }
        ReEncryptionAttributes other = (ReEncryptionAttributes)obj;
        return Objects.equals(this.symmetric(), other.symmetric()) && Objects.equals(this.dukpt(), other.dukpt());
    }

    public final String toString() {
        return ToString.builder((String)"ReEncryptionAttributes").add("Symmetric", (Object)this.symmetric()).add("Dukpt", (Object)this.dukpt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Symmetric": {
                return Optional.ofNullable(clazz.cast(this.symmetric()));
            }
            case "Dukpt": {
                return Optional.ofNullable(clazz.cast(this.dukpt()));
            }
        }
        return Optional.empty();
    }

    public static ReEncryptionAttributes fromSymmetric(SymmetricEncryptionAttributes symmetric) {
        return (ReEncryptionAttributes)ReEncryptionAttributes.builder().symmetric(symmetric).build();
    }

    public static ReEncryptionAttributes fromSymmetric(Consumer<SymmetricEncryptionAttributes.Builder> symmetric) {
        SymmetricEncryptionAttributes.Builder builder = SymmetricEncryptionAttributes.builder();
        symmetric.accept(builder);
        return ReEncryptionAttributes.fromSymmetric((SymmetricEncryptionAttributes)builder.build());
    }

    public static ReEncryptionAttributes fromDukpt(DukptEncryptionAttributes dukpt) {
        return (ReEncryptionAttributes)ReEncryptionAttributes.builder().dukpt(dukpt).build();
    }

    public static ReEncryptionAttributes fromDukpt(Consumer<DukptEncryptionAttributes.Builder> dukpt) {
        DukptEncryptionAttributes.Builder builder = DukptEncryptionAttributes.builder();
        dukpt.accept(builder);
        return ReEncryptionAttributes.fromDukpt((DukptEncryptionAttributes)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReEncryptionAttributes, T> g) {
        return obj -> g.apply((ReEncryptionAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        SYMMETRIC,
        DUKPT,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private SymmetricEncryptionAttributes symmetric;
        private DukptEncryptionAttributes dukpt;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ReEncryptionAttributes model) {
            this.symmetric(model.symmetric);
            this.dukpt(model.dukpt);
        }

        public final SymmetricEncryptionAttributes.Builder getSymmetric() {
            return this.symmetric != null ? this.symmetric.toBuilder() : null;
        }

        public final void setSymmetric(SymmetricEncryptionAttributes.BuilderImpl symmetric) {
            SymmetricEncryptionAttributes oldValue = this.symmetric;
            this.symmetric = symmetric != null ? symmetric.build() : null;
            this.handleUnionValueChange(Type.SYMMETRIC, oldValue, this.symmetric);
        }

        @Override
        public final Builder symmetric(SymmetricEncryptionAttributes symmetric) {
            SymmetricEncryptionAttributes oldValue = this.symmetric;
            this.symmetric = symmetric;
            this.handleUnionValueChange(Type.SYMMETRIC, oldValue, this.symmetric);
            return this;
        }

        public final DukptEncryptionAttributes.Builder getDukpt() {
            return this.dukpt != null ? this.dukpt.toBuilder() : null;
        }

        public final void setDukpt(DukptEncryptionAttributes.BuilderImpl dukpt) {
            DukptEncryptionAttributes oldValue = this.dukpt;
            this.dukpt = dukpt != null ? dukpt.build() : null;
            this.handleUnionValueChange(Type.DUKPT, oldValue, this.dukpt);
        }

        @Override
        public final Builder dukpt(DukptEncryptionAttributes dukpt) {
            DukptEncryptionAttributes oldValue = this.dukpt;
            this.dukpt = dukpt;
            this.handleUnionValueChange(Type.DUKPT, oldValue, this.dukpt);
            return this;
        }

        public ReEncryptionAttributes build() {
            return new ReEncryptionAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReEncryptionAttributes> {
        public Builder symmetric(SymmetricEncryptionAttributes var1);

        default public Builder symmetric(Consumer<SymmetricEncryptionAttributes.Builder> symmetric) {
            return this.symmetric((SymmetricEncryptionAttributes)((SymmetricEncryptionAttributes.Builder)SymmetricEncryptionAttributes.builder().applyMutation(symmetric)).build());
        }

        public Builder dukpt(DukptEncryptionAttributes var1);

        default public Builder dukpt(Consumer<DukptEncryptionAttributes.Builder> dukpt) {
            return this.dukpt((DukptEncryptionAttributes)((DukptEncryptionAttributes.Builder)DukptEncryptionAttributes.builder().applyMutation(dukpt)).build());
        }
    }
}

