/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptographydata.model.CryptogramAuthResponse;
import software.amazon.awssdk.services.paymentcryptographydata.model.MajorKeyDerivationMode;
import software.amazon.awssdk.services.paymentcryptographydata.model.PaymentCryptographyDataRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyDerivation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VerifyAuthRequestCryptogramRequest
extends PaymentCryptographyDataRequest
implements ToCopyableBuilder<Builder, VerifyAuthRequestCryptogramRequest> {
    private static final SdkField<String> KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyIdentifier").getter(VerifyAuthRequestCryptogramRequest.getter(VerifyAuthRequestCryptogramRequest::keyIdentifier)).setter(VerifyAuthRequestCryptogramRequest.setter(Builder::keyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyIdentifier").build()}).build();
    private static final SdkField<String> TRANSACTION_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransactionData").getter(VerifyAuthRequestCryptogramRequest.getter(VerifyAuthRequestCryptogramRequest::transactionData)).setter(VerifyAuthRequestCryptogramRequest.setter(Builder::transactionData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransactionData").build()}).build();
    private static final SdkField<String> AUTH_REQUEST_CRYPTOGRAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthRequestCryptogram").getter(VerifyAuthRequestCryptogramRequest.getter(VerifyAuthRequestCryptogramRequest::authRequestCryptogram)).setter(VerifyAuthRequestCryptogramRequest.setter(Builder::authRequestCryptogram)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthRequestCryptogram").build()}).build();
    private static final SdkField<String> MAJOR_KEY_DERIVATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MajorKeyDerivationMode").getter(VerifyAuthRequestCryptogramRequest.getter(VerifyAuthRequestCryptogramRequest::majorKeyDerivationModeAsString)).setter(VerifyAuthRequestCryptogramRequest.setter(Builder::majorKeyDerivationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MajorKeyDerivationMode").build()}).build();
    private static final SdkField<SessionKeyDerivation> SESSION_KEY_DERIVATION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SessionKeyDerivationAttributes").getter(VerifyAuthRequestCryptogramRequest.getter(VerifyAuthRequestCryptogramRequest::sessionKeyDerivationAttributes)).setter(VerifyAuthRequestCryptogramRequest.setter(Builder::sessionKeyDerivationAttributes)).constructor(SessionKeyDerivation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionKeyDerivationAttributes").build()}).build();
    private static final SdkField<CryptogramAuthResponse> AUTH_RESPONSE_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AuthResponseAttributes").getter(VerifyAuthRequestCryptogramRequest.getter(VerifyAuthRequestCryptogramRequest::authResponseAttributes)).setter(VerifyAuthRequestCryptogramRequest.setter(Builder::authResponseAttributes)).constructor(CryptogramAuthResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthResponseAttributes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_IDENTIFIER_FIELD, TRANSACTION_DATA_FIELD, AUTH_REQUEST_CRYPTOGRAM_FIELD, MAJOR_KEY_DERIVATION_MODE_FIELD, SESSION_KEY_DERIVATION_ATTRIBUTES_FIELD, AUTH_RESPONSE_ATTRIBUTES_FIELD));
    private final String keyIdentifier;
    private final String transactionData;
    private final String authRequestCryptogram;
    private final String majorKeyDerivationMode;
    private final SessionKeyDerivation sessionKeyDerivationAttributes;
    private final CryptogramAuthResponse authResponseAttributes;

    private VerifyAuthRequestCryptogramRequest(BuilderImpl builder) {
        super(builder);
        this.keyIdentifier = builder.keyIdentifier;
        this.transactionData = builder.transactionData;
        this.authRequestCryptogram = builder.authRequestCryptogram;
        this.majorKeyDerivationMode = builder.majorKeyDerivationMode;
        this.sessionKeyDerivationAttributes = builder.sessionKeyDerivationAttributes;
        this.authResponseAttributes = builder.authResponseAttributes;
    }

    public final String keyIdentifier() {
        return this.keyIdentifier;
    }

    public final String transactionData() {
        return this.transactionData;
    }

    public final String authRequestCryptogram() {
        return this.authRequestCryptogram;
    }

    public final MajorKeyDerivationMode majorKeyDerivationMode() {
        return MajorKeyDerivationMode.fromValue(this.majorKeyDerivationMode);
    }

    public final String majorKeyDerivationModeAsString() {
        return this.majorKeyDerivationMode;
    }

    public final SessionKeyDerivation sessionKeyDerivationAttributes() {
        return this.sessionKeyDerivationAttributes;
    }

    public final CryptogramAuthResponse authResponseAttributes() {
        return this.authResponseAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.transactionData());
        hashCode = 31 * hashCode + Objects.hashCode(this.authRequestCryptogram());
        hashCode = 31 * hashCode + Objects.hashCode(this.majorKeyDerivationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionKeyDerivationAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.authResponseAttributes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyAuthRequestCryptogramRequest)) {
            return false;
        }
        VerifyAuthRequestCryptogramRequest other = (VerifyAuthRequestCryptogramRequest)((Object)obj);
        return Objects.equals(this.keyIdentifier(), other.keyIdentifier()) && Objects.equals(this.transactionData(), other.transactionData()) && Objects.equals(this.authRequestCryptogram(), other.authRequestCryptogram()) && Objects.equals(this.majorKeyDerivationModeAsString(), other.majorKeyDerivationModeAsString()) && Objects.equals(this.sessionKeyDerivationAttributes(), other.sessionKeyDerivationAttributes()) && Objects.equals(this.authResponseAttributes(), other.authResponseAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"VerifyAuthRequestCryptogramRequest").add("KeyIdentifier", (Object)this.keyIdentifier()).add("TransactionData", (Object)this.transactionData()).add("AuthRequestCryptogram", (Object)this.authRequestCryptogram()).add("MajorKeyDerivationMode", (Object)this.majorKeyDerivationModeAsString()).add("SessionKeyDerivationAttributes", (Object)this.sessionKeyDerivationAttributes()).add("AuthResponseAttributes", (Object)this.authResponseAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.keyIdentifier()));
            }
            case "TransactionData": {
                return Optional.ofNullable(clazz.cast(this.transactionData()));
            }
            case "AuthRequestCryptogram": {
                return Optional.ofNullable(clazz.cast(this.authRequestCryptogram()));
            }
            case "MajorKeyDerivationMode": {
                return Optional.ofNullable(clazz.cast(this.majorKeyDerivationModeAsString()));
            }
            case "SessionKeyDerivationAttributes": {
                return Optional.ofNullable(clazz.cast(this.sessionKeyDerivationAttributes()));
            }
            case "AuthResponseAttributes": {
                return Optional.ofNullable(clazz.cast(this.authResponseAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VerifyAuthRequestCryptogramRequest, T> g) {
        return obj -> g.apply((VerifyAuthRequestCryptogramRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PaymentCryptographyDataRequest.BuilderImpl
    implements Builder {
        private String keyIdentifier;
        private String transactionData;
        private String authRequestCryptogram;
        private String majorKeyDerivationMode;
        private SessionKeyDerivation sessionKeyDerivationAttributes;
        private CryptogramAuthResponse authResponseAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyAuthRequestCryptogramRequest model) {
            super(model);
            this.keyIdentifier(model.keyIdentifier);
            this.transactionData(model.transactionData);
            this.authRequestCryptogram(model.authRequestCryptogram);
            this.majorKeyDerivationMode(model.majorKeyDerivationMode);
            this.sessionKeyDerivationAttributes(model.sessionKeyDerivationAttributes);
            this.authResponseAttributes(model.authResponseAttributes);
        }

        public final String getKeyIdentifier() {
            return this.keyIdentifier;
        }

        public final void setKeyIdentifier(String keyIdentifier) {
            this.keyIdentifier = keyIdentifier;
        }

        @Override
        public final Builder keyIdentifier(String keyIdentifier) {
            this.keyIdentifier = keyIdentifier;
            return this;
        }

        public final String getTransactionData() {
            return this.transactionData;
        }

        public final void setTransactionData(String transactionData) {
            this.transactionData = transactionData;
        }

        @Override
        public final Builder transactionData(String transactionData) {
            this.transactionData = transactionData;
            return this;
        }

        public final String getAuthRequestCryptogram() {
            return this.authRequestCryptogram;
        }

        public final void setAuthRequestCryptogram(String authRequestCryptogram) {
            this.authRequestCryptogram = authRequestCryptogram;
        }

        @Override
        public final Builder authRequestCryptogram(String authRequestCryptogram) {
            this.authRequestCryptogram = authRequestCryptogram;
            return this;
        }

        public final String getMajorKeyDerivationMode() {
            return this.majorKeyDerivationMode;
        }

        public final void setMajorKeyDerivationMode(String majorKeyDerivationMode) {
            this.majorKeyDerivationMode = majorKeyDerivationMode;
        }

        @Override
        public final Builder majorKeyDerivationMode(String majorKeyDerivationMode) {
            this.majorKeyDerivationMode = majorKeyDerivationMode;
            return this;
        }

        @Override
        public final Builder majorKeyDerivationMode(MajorKeyDerivationMode majorKeyDerivationMode) {
            this.majorKeyDerivationMode(majorKeyDerivationMode == null ? null : majorKeyDerivationMode.toString());
            return this;
        }

        public final SessionKeyDerivation.Builder getSessionKeyDerivationAttributes() {
            return this.sessionKeyDerivationAttributes != null ? this.sessionKeyDerivationAttributes.toBuilder() : null;
        }

        public final void setSessionKeyDerivationAttributes(SessionKeyDerivation.BuilderImpl sessionKeyDerivationAttributes) {
            this.sessionKeyDerivationAttributes = sessionKeyDerivationAttributes != null ? sessionKeyDerivationAttributes.build() : null;
        }

        @Override
        public final Builder sessionKeyDerivationAttributes(SessionKeyDerivation sessionKeyDerivationAttributes) {
            this.sessionKeyDerivationAttributes = sessionKeyDerivationAttributes;
            return this;
        }

        public final CryptogramAuthResponse.Builder getAuthResponseAttributes() {
            return this.authResponseAttributes != null ? this.authResponseAttributes.toBuilder() : null;
        }

        public final void setAuthResponseAttributes(CryptogramAuthResponse.BuilderImpl authResponseAttributes) {
            this.authResponseAttributes = authResponseAttributes != null ? authResponseAttributes.build() : null;
        }

        @Override
        public final Builder authResponseAttributes(CryptogramAuthResponse authResponseAttributes) {
            this.authResponseAttributes = authResponseAttributes;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public VerifyAuthRequestCryptogramRequest build() {
            return new VerifyAuthRequestCryptogramRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PaymentCryptographyDataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, VerifyAuthRequestCryptogramRequest> {
        public Builder keyIdentifier(String var1);

        public Builder transactionData(String var1);

        public Builder authRequestCryptogram(String var1);

        public Builder majorKeyDerivationMode(String var1);

        public Builder majorKeyDerivationMode(MajorKeyDerivationMode var1);

        public Builder sessionKeyDerivationAttributes(SessionKeyDerivation var1);

        default public Builder sessionKeyDerivationAttributes(Consumer<SessionKeyDerivation.Builder> sessionKeyDerivationAttributes) {
            return this.sessionKeyDerivationAttributes((SessionKeyDerivation)((SessionKeyDerivation.Builder)SessionKeyDerivation.builder().applyMutation(sessionKeyDerivationAttributes)).build());
        }

        public Builder authResponseAttributes(CryptogramAuthResponse var1);

        default public Builder authResponseAttributes(Consumer<CryptogramAuthResponse.Builder> authResponseAttributes) {
            return this.authResponseAttributes((CryptogramAuthResponse)((CryptogramAuthResponse.Builder)CryptogramAuthResponse.builder().applyMutation(authResponseAttributes)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

