/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptographydata.model.PaymentCryptographyDataResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VerifyCardValidationDataResponse
extends PaymentCryptographyDataResponse
implements ToCopyableBuilder<Builder, VerifyCardValidationDataResponse> {
    private static final SdkField<String> KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyArn").getter(VerifyCardValidationDataResponse.getter(VerifyCardValidationDataResponse::keyArn)).setter(VerifyCardValidationDataResponse.setter(Builder::keyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyArn").build()}).build();
    private static final SdkField<String> KEY_CHECK_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyCheckValue").getter(VerifyCardValidationDataResponse.getter(VerifyCardValidationDataResponse::keyCheckValue)).setter(VerifyCardValidationDataResponse.setter(Builder::keyCheckValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyCheckValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ARN_FIELD, KEY_CHECK_VALUE_FIELD));
    private final String keyArn;
    private final String keyCheckValue;

    private VerifyCardValidationDataResponse(BuilderImpl builder) {
        super(builder);
        this.keyArn = builder.keyArn;
        this.keyCheckValue = builder.keyCheckValue;
    }

    public final String keyArn() {
        return this.keyArn;
    }

    public final String keyCheckValue() {
        return this.keyCheckValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyCheckValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyCardValidationDataResponse)) {
            return false;
        }
        VerifyCardValidationDataResponse other = (VerifyCardValidationDataResponse)((Object)obj);
        return Objects.equals(this.keyArn(), other.keyArn()) && Objects.equals(this.keyCheckValue(), other.keyCheckValue());
    }

    public final String toString() {
        return ToString.builder((String)"VerifyCardValidationDataResponse").add("KeyArn", (Object)this.keyArn()).add("KeyCheckValue", (Object)this.keyCheckValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyArn": {
                return Optional.ofNullable(clazz.cast(this.keyArn()));
            }
            case "KeyCheckValue": {
                return Optional.ofNullable(clazz.cast(this.keyCheckValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VerifyCardValidationDataResponse, T> g) {
        return obj -> g.apply((VerifyCardValidationDataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PaymentCryptographyDataResponse.BuilderImpl
    implements Builder {
        private String keyArn;
        private String keyCheckValue;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyCardValidationDataResponse model) {
            super(model);
            this.keyArn(model.keyArn);
            this.keyCheckValue(model.keyCheckValue);
        }

        public final String getKeyArn() {
            return this.keyArn;
        }

        public final void setKeyArn(String keyArn) {
            this.keyArn = keyArn;
        }

        @Override
        public final Builder keyArn(String keyArn) {
            this.keyArn = keyArn;
            return this;
        }

        public final String getKeyCheckValue() {
            return this.keyCheckValue;
        }

        public final void setKeyCheckValue(String keyCheckValue) {
            this.keyCheckValue = keyCheckValue;
        }

        @Override
        public final Builder keyCheckValue(String keyCheckValue) {
            this.keyCheckValue = keyCheckValue;
            return this;
        }

        @Override
        public VerifyCardValidationDataResponse build() {
            return new VerifyCardValidationDataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PaymentCryptographyDataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, VerifyCardValidationDataResponse> {
        public Builder keyArn(String var1);

        public Builder keyCheckValue(String var1);
    }
}

