/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.paymentcryptographydata.PaymentCryptographyDataClient;
import software.amazon.awssdk.services.paymentcryptographydata.PaymentCryptographyDataServiceClientConfiguration;
import software.amazon.awssdk.services.paymentcryptographydata.internal.PaymentCryptographyDataServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.paymentcryptographydata.model.AccessDeniedException;
import software.amazon.awssdk.services.paymentcryptographydata.model.DecryptDataRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.DecryptDataResponse;
import software.amazon.awssdk.services.paymentcryptographydata.model.EncryptDataRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.EncryptDataResponse;
import software.amazon.awssdk.services.paymentcryptographydata.model.GenerateCardValidationDataRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.GenerateCardValidationDataResponse;
import software.amazon.awssdk.services.paymentcryptographydata.model.GenerateMacRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.GenerateMacResponse;
import software.amazon.awssdk.services.paymentcryptographydata.model.GeneratePinDataRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.GeneratePinDataResponse;
import software.amazon.awssdk.services.paymentcryptographydata.model.InternalServerException;
import software.amazon.awssdk.services.paymentcryptographydata.model.PaymentCryptographyDataException;
import software.amazon.awssdk.services.paymentcryptographydata.model.ReEncryptDataRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.ReEncryptDataResponse;
import software.amazon.awssdk.services.paymentcryptographydata.model.ResourceNotFoundException;
import software.amazon.awssdk.services.paymentcryptographydata.model.ThrottlingException;
import software.amazon.awssdk.services.paymentcryptographydata.model.TranslatePinDataRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.TranslatePinDataResponse;
import software.amazon.awssdk.services.paymentcryptographydata.model.ValidationException;
import software.amazon.awssdk.services.paymentcryptographydata.model.VerificationFailedException;
import software.amazon.awssdk.services.paymentcryptographydata.model.VerifyAuthRequestCryptogramRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.VerifyAuthRequestCryptogramResponse;
import software.amazon.awssdk.services.paymentcryptographydata.model.VerifyCardValidationDataRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.VerifyCardValidationDataResponse;
import software.amazon.awssdk.services.paymentcryptographydata.model.VerifyMacRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.VerifyMacResponse;
import software.amazon.awssdk.services.paymentcryptographydata.model.VerifyPinDataRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.VerifyPinDataResponse;
import software.amazon.awssdk.services.paymentcryptographydata.transform.DecryptDataRequestMarshaller;
import software.amazon.awssdk.services.paymentcryptographydata.transform.EncryptDataRequestMarshaller;
import software.amazon.awssdk.services.paymentcryptographydata.transform.GenerateCardValidationDataRequestMarshaller;
import software.amazon.awssdk.services.paymentcryptographydata.transform.GenerateMacRequestMarshaller;
import software.amazon.awssdk.services.paymentcryptographydata.transform.GeneratePinDataRequestMarshaller;
import software.amazon.awssdk.services.paymentcryptographydata.transform.ReEncryptDataRequestMarshaller;
import software.amazon.awssdk.services.paymentcryptographydata.transform.TranslatePinDataRequestMarshaller;
import software.amazon.awssdk.services.paymentcryptographydata.transform.VerifyAuthRequestCryptogramRequestMarshaller;
import software.amazon.awssdk.services.paymentcryptographydata.transform.VerifyCardValidationDataRequestMarshaller;
import software.amazon.awssdk.services.paymentcryptographydata.transform.VerifyMacRequestMarshaller;
import software.amazon.awssdk.services.paymentcryptographydata.transform.VerifyPinDataRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultPaymentCryptographyDataClient
implements PaymentCryptographyDataClient {
    private static final Logger log = Logger.loggerFor(DefaultPaymentCryptographyDataClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final PaymentCryptographyDataServiceClientConfiguration serviceClientConfiguration;

    protected DefaultPaymentCryptographyDataClient(PaymentCryptographyDataServiceClientConfiguration serviceClientConfiguration, SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DecryptDataResponse decryptData(DecryptDataRequest decryptDataRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DecryptDataResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)decryptDataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPaymentCryptographyDataClient.resolveMetricPublishers(clientConfiguration, decryptDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Payment Cryptography Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DecryptData");
            DecryptDataResponse decryptDataResponse = (DecryptDataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DecryptData").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)decryptDataRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DecryptDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return decryptDataResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPaymentCryptographyDataClient.lambda$decryptData$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EncryptDataResponse encryptData(EncryptDataRequest encryptDataRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EncryptDataResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)encryptDataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPaymentCryptographyDataClient.resolveMetricPublishers(clientConfiguration, encryptDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Payment Cryptography Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EncryptData");
            EncryptDataResponse encryptDataResponse = (EncryptDataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EncryptData").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)encryptDataRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EncryptDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return encryptDataResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPaymentCryptographyDataClient.lambda$encryptData$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenerateCardValidationDataResponse generateCardValidationData(GenerateCardValidationDataRequest generateCardValidationDataRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GenerateCardValidationDataResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)generateCardValidationDataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPaymentCryptographyDataClient.resolveMetricPublishers(clientConfiguration, generateCardValidationDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Payment Cryptography Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GenerateCardValidationData");
            GenerateCardValidationDataResponse generateCardValidationDataResponse = (GenerateCardValidationDataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GenerateCardValidationData").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)generateCardValidationDataRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GenerateCardValidationDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return generateCardValidationDataResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPaymentCryptographyDataClient.lambda$generateCardValidationData$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenerateMacResponse generateMac(GenerateMacRequest generateMacRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GenerateMacResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)generateMacRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPaymentCryptographyDataClient.resolveMetricPublishers(clientConfiguration, generateMacRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Payment Cryptography Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GenerateMac");
            GenerateMacResponse generateMacResponse = (GenerateMacResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GenerateMac").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)generateMacRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GenerateMacRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return generateMacResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPaymentCryptographyDataClient.lambda$generateMac$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GeneratePinDataResponse generatePinData(GeneratePinDataRequest generatePinDataRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GeneratePinDataResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)generatePinDataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPaymentCryptographyDataClient.resolveMetricPublishers(clientConfiguration, generatePinDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Payment Cryptography Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GeneratePinData");
            GeneratePinDataResponse generatePinDataResponse = (GeneratePinDataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GeneratePinData").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)generatePinDataRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GeneratePinDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return generatePinDataResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPaymentCryptographyDataClient.lambda$generatePinData$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReEncryptDataResponse reEncryptData(ReEncryptDataRequest reEncryptDataRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ReEncryptDataResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)reEncryptDataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPaymentCryptographyDataClient.resolveMetricPublishers(clientConfiguration, reEncryptDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Payment Cryptography Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ReEncryptData");
            ReEncryptDataResponse reEncryptDataResponse = (ReEncryptDataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ReEncryptData").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)reEncryptDataRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ReEncryptDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return reEncryptDataResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPaymentCryptographyDataClient.lambda$reEncryptData$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TranslatePinDataResponse translatePinData(TranslatePinDataRequest translatePinDataRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TranslatePinDataResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)translatePinDataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPaymentCryptographyDataClient.resolveMetricPublishers(clientConfiguration, translatePinDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Payment Cryptography Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TranslatePinData");
            TranslatePinDataResponse translatePinDataResponse = (TranslatePinDataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TranslatePinData").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)translatePinDataRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TranslatePinDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return translatePinDataResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPaymentCryptographyDataClient.lambda$translatePinData$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VerifyAuthRequestCryptogramResponse verifyAuthRequestCryptogram(VerifyAuthRequestCryptogramRequest verifyAuthRequestCryptogramRequest) throws ValidationException, VerificationFailedException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, VerifyAuthRequestCryptogramResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)verifyAuthRequestCryptogramRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPaymentCryptographyDataClient.resolveMetricPublishers(clientConfiguration, verifyAuthRequestCryptogramRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Payment Cryptography Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"VerifyAuthRequestCryptogram");
            VerifyAuthRequestCryptogramResponse verifyAuthRequestCryptogramResponse = (VerifyAuthRequestCryptogramResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("VerifyAuthRequestCryptogram").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)verifyAuthRequestCryptogramRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new VerifyAuthRequestCryptogramRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return verifyAuthRequestCryptogramResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPaymentCryptographyDataClient.lambda$verifyAuthRequestCryptogram$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VerifyCardValidationDataResponse verifyCardValidationData(VerifyCardValidationDataRequest verifyCardValidationDataRequest) throws ValidationException, VerificationFailedException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, VerifyCardValidationDataResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)verifyCardValidationDataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPaymentCryptographyDataClient.resolveMetricPublishers(clientConfiguration, verifyCardValidationDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Payment Cryptography Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"VerifyCardValidationData");
            VerifyCardValidationDataResponse verifyCardValidationDataResponse = (VerifyCardValidationDataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("VerifyCardValidationData").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)verifyCardValidationDataRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new VerifyCardValidationDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return verifyCardValidationDataResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPaymentCryptographyDataClient.lambda$verifyCardValidationData$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VerifyMacResponse verifyMac(VerifyMacRequest verifyMacRequest) throws ValidationException, VerificationFailedException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, VerifyMacResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)verifyMacRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPaymentCryptographyDataClient.resolveMetricPublishers(clientConfiguration, verifyMacRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Payment Cryptography Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"VerifyMac");
            VerifyMacResponse verifyMacResponse = (VerifyMacResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("VerifyMac").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)verifyMacRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new VerifyMacRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return verifyMacResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPaymentCryptographyDataClient.lambda$verifyMac$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VerifyPinDataResponse verifyPinData(VerifyPinDataRequest verifyPinDataRequest) throws ValidationException, VerificationFailedException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, VerifyPinDataResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)verifyPinDataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPaymentCryptographyDataClient.resolveMetricPublishers(clientConfiguration, verifyPinDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Payment Cryptography Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"VerifyPinData");
            VerifyPinDataResponse verifyPinDataResponse = (VerifyPinDataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("VerifyPinData").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)verifyPinDataRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new VerifyPinDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return verifyPinDataResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPaymentCryptographyDataClient.lambda$verifyPinData$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "payment-cryptography";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        PaymentCryptographyDataServiceClientConfigurationBuilder.BuilderInternal serviceConfigBuilder = PaymentCryptographyDataServiceClientConfigurationBuilder.builder(clientConfiguration.toBuilder());
        serviceConfigBuilder.overrideConfiguration(this.serviceClientConfiguration.overrideConfiguration());
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        return serviceConfigBuilder.buildSdkClientConfiguration();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(PaymentCryptographyDataException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("VerificationFailedException").exceptionBuilderSupplier(VerificationFailedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    @Override
    public final PaymentCryptographyDataServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$verifyPinData$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$verifyMac$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$verifyCardValidationData$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$verifyAuthRequestCryptogram$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$translatePinData$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$reEncryptData$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$generatePinData$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$generateMac$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$generateCardValidationData$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$encryptData$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$decryptData$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

