/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class VerifyCardValidationDataRequest extends PaymentCryptographyDataRequest implements
        ToCopyableBuilder<VerifyCardValidationDataRequest.Builder, VerifyCardValidationDataRequest> {
    private static final SdkField<String> KEY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyIdentifier").getter(getter(VerifyCardValidationDataRequest::keyIdentifier))
            .setter(setter(Builder::keyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyIdentifier").build()).build();

    private static final SdkField<String> PRIMARY_ACCOUNT_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimaryAccountNumber").getter(getter(VerifyCardValidationDataRequest::primaryAccountNumber))
            .setter(setter(Builder::primaryAccountNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryAccountNumber").build())
            .build();

    private static final SdkField<String> VALIDATION_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValidationData").getter(getter(VerifyCardValidationDataRequest::validationData))
            .setter(setter(Builder::validationData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationData").build()).build();

    private static final SdkField<CardVerificationAttributes> VERIFICATION_ATTRIBUTES_FIELD = SdkField
            .<CardVerificationAttributes> builder(MarshallingType.SDK_POJO).memberName("VerificationAttributes")
            .getter(getter(VerifyCardValidationDataRequest::verificationAttributes))
            .setter(setter(Builder::verificationAttributes)).constructor(CardVerificationAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationAttributes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_IDENTIFIER_FIELD,
            PRIMARY_ACCOUNT_NUMBER_FIELD, VALIDATION_DATA_FIELD, VERIFICATION_ATTRIBUTES_FIELD));

    private final String keyIdentifier;

    private final String primaryAccountNumber;

    private final String validationData;

    private final CardVerificationAttributes verificationAttributes;

    private VerifyCardValidationDataRequest(BuilderImpl builder) {
        super(builder);
        this.keyIdentifier = builder.keyIdentifier;
        this.primaryAccountNumber = builder.primaryAccountNumber;
        this.validationData = builder.validationData;
        this.verificationAttributes = builder.verificationAttributes;
    }

    /**
     * <p>
     * The <code>keyARN</code> of the CVK encryption key that Amazon Web Services Payment Cryptography uses to verify
     * card data.
     * </p>
     * 
     * @return The <code>keyARN</code> of the CVK encryption key that Amazon Web Services Payment Cryptography uses to
     *         verify card data.
     */
    public final String keyIdentifier() {
        return keyIdentifier;
    }

    /**
     * <p>
     * The Primary Account Number (PAN), a unique identifier for a payment credit or debit card that associates the card
     * with a specific account holder.
     * </p>
     * 
     * @return The Primary Account Number (PAN), a unique identifier for a payment credit or debit card that associates
     *         the card with a specific account holder.
     */
    public final String primaryAccountNumber() {
        return primaryAccountNumber;
    }

    /**
     * <p>
     * The CVV or CSC value for use for card data verification within Amazon Web Services Payment Cryptography.
     * </p>
     * 
     * @return The CVV or CSC value for use for card data verification within Amazon Web Services Payment Cryptography.
     */
    public final String validationData() {
        return validationData;
    }

    /**
     * <p>
     * The algorithm to use for verification of card data within Amazon Web Services Payment Cryptography.
     * </p>
     * 
     * @return The algorithm to use for verification of card data within Amazon Web Services Payment Cryptography.
     */
    public final CardVerificationAttributes verificationAttributes() {
        return verificationAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(keyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(primaryAccountNumber());
        hashCode = 31 * hashCode + Objects.hashCode(validationData());
        hashCode = 31 * hashCode + Objects.hashCode(verificationAttributes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyCardValidationDataRequest)) {
            return false;
        }
        VerifyCardValidationDataRequest other = (VerifyCardValidationDataRequest) obj;
        return Objects.equals(keyIdentifier(), other.keyIdentifier())
                && Objects.equals(primaryAccountNumber(), other.primaryAccountNumber())
                && Objects.equals(validationData(), other.validationData())
                && Objects.equals(verificationAttributes(), other.verificationAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VerifyCardValidationDataRequest").add("KeyIdentifier", keyIdentifier())
                .add("PrimaryAccountNumber", primaryAccountNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ValidationData", validationData()).add("VerificationAttributes", verificationAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyIdentifier":
            return Optional.ofNullable(clazz.cast(keyIdentifier()));
        case "PrimaryAccountNumber":
            return Optional.ofNullable(clazz.cast(primaryAccountNumber()));
        case "ValidationData":
            return Optional.ofNullable(clazz.cast(validationData()));
        case "VerificationAttributes":
            return Optional.ofNullable(clazz.cast(verificationAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VerifyCardValidationDataRequest, T> g) {
        return obj -> g.apply((VerifyCardValidationDataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PaymentCryptographyDataRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, VerifyCardValidationDataRequest> {
        /**
         * <p>
         * The <code>keyARN</code> of the CVK encryption key that Amazon Web Services Payment Cryptography uses to
         * verify card data.
         * </p>
         * 
         * @param keyIdentifier
         *        The <code>keyARN</code> of the CVK encryption key that Amazon Web Services Payment Cryptography uses
         *        to verify card data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyIdentifier(String keyIdentifier);

        /**
         * <p>
         * The Primary Account Number (PAN), a unique identifier for a payment credit or debit card that associates the
         * card with a specific account holder.
         * </p>
         * 
         * @param primaryAccountNumber
         *        The Primary Account Number (PAN), a unique identifier for a payment credit or debit card that
         *        associates the card with a specific account holder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryAccountNumber(String primaryAccountNumber);

        /**
         * <p>
         * The CVV or CSC value for use for card data verification within Amazon Web Services Payment Cryptography.
         * </p>
         * 
         * @param validationData
         *        The CVV or CSC value for use for card data verification within Amazon Web Services Payment
         *        Cryptography.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationData(String validationData);

        /**
         * <p>
         * The algorithm to use for verification of card data within Amazon Web Services Payment Cryptography.
         * </p>
         * 
         * @param verificationAttributes
         *        The algorithm to use for verification of card data within Amazon Web Services Payment Cryptography.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verificationAttributes(CardVerificationAttributes verificationAttributes);

        /**
         * <p>
         * The algorithm to use for verification of card data within Amazon Web Services Payment Cryptography.
         * </p>
         * This is a convenience method that creates an instance of the {@link CardVerificationAttributes.Builder}
         * avoiding the need to create one manually via {@link CardVerificationAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CardVerificationAttributes.Builder#build()} is called immediately
         * and its result is passed to {@link #verificationAttributes(CardVerificationAttributes)}.
         * 
         * @param verificationAttributes
         *        a consumer that will call methods on {@link CardVerificationAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #verificationAttributes(CardVerificationAttributes)
         */
        default Builder verificationAttributes(Consumer<CardVerificationAttributes.Builder> verificationAttributes) {
            return verificationAttributes(CardVerificationAttributes.builder().applyMutation(verificationAttributes).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PaymentCryptographyDataRequest.BuilderImpl implements Builder {
        private String keyIdentifier;

        private String primaryAccountNumber;

        private String validationData;

        private CardVerificationAttributes verificationAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyCardValidationDataRequest model) {
            super(model);
            keyIdentifier(model.keyIdentifier);
            primaryAccountNumber(model.primaryAccountNumber);
            validationData(model.validationData);
            verificationAttributes(model.verificationAttributes);
        }

        public final String getKeyIdentifier() {
            return keyIdentifier;
        }

        public final void setKeyIdentifier(String keyIdentifier) {
            this.keyIdentifier = keyIdentifier;
        }

        @Override
        public final Builder keyIdentifier(String keyIdentifier) {
            this.keyIdentifier = keyIdentifier;
            return this;
        }

        public final String getPrimaryAccountNumber() {
            return primaryAccountNumber;
        }

        public final void setPrimaryAccountNumber(String primaryAccountNumber) {
            this.primaryAccountNumber = primaryAccountNumber;
        }

        @Override
        public final Builder primaryAccountNumber(String primaryAccountNumber) {
            this.primaryAccountNumber = primaryAccountNumber;
            return this;
        }

        public final String getValidationData() {
            return validationData;
        }

        public final void setValidationData(String validationData) {
            this.validationData = validationData;
        }

        @Override
        public final Builder validationData(String validationData) {
            this.validationData = validationData;
            return this;
        }

        public final CardVerificationAttributes.Builder getVerificationAttributes() {
            return verificationAttributes != null ? verificationAttributes.toBuilder() : null;
        }

        public final void setVerificationAttributes(CardVerificationAttributes.BuilderImpl verificationAttributes) {
            this.verificationAttributes = verificationAttributes != null ? verificationAttributes.build() : null;
        }

        @Override
        public final Builder verificationAttributes(CardVerificationAttributes verificationAttributes) {
            this.verificationAttributes = verificationAttributes;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public VerifyCardValidationDataRequest build() {
            return new VerifyCardValidationDataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
