/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptography.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCertificateSigningRequestResponse extends PaymentCryptographyResponse implements
        ToCopyableBuilder<GetCertificateSigningRequestResponse.Builder, GetCertificateSigningRequestResponse> {
    private static final SdkField<String> CERTIFICATE_SIGNING_REQUEST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateSigningRequest")
            .getter(getter(GetCertificateSigningRequestResponse::certificateSigningRequest))
            .setter(setter(Builder::certificateSigningRequest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateSigningRequest").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CERTIFICATE_SIGNING_REQUEST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String certificateSigningRequest;

    private GetCertificateSigningRequestResponse(BuilderImpl builder) {
        super(builder);
        this.certificateSigningRequest = builder.certificateSigningRequest;
    }

    /**
     * <p>
     * The certificate signing request generated using the key pair associated with the key identifier.
     * </p>
     * 
     * @return The certificate signing request generated using the key pair associated with the key identifier.
     */
    public final String certificateSigningRequest() {
        return certificateSigningRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(certificateSigningRequest());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCertificateSigningRequestResponse)) {
            return false;
        }
        GetCertificateSigningRequestResponse other = (GetCertificateSigningRequestResponse) obj;
        return Objects.equals(certificateSigningRequest(), other.certificateSigningRequest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCertificateSigningRequestResponse")
                .add("CertificateSigningRequest", certificateSigningRequest() == null ? null : "*** Sensitive Data Redacted ***")
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CertificateSigningRequest":
            return Optional.ofNullable(clazz.cast(certificateSigningRequest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CertificateSigningRequest", CERTIFICATE_SIGNING_REQUEST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCertificateSigningRequestResponse, T> g) {
        return obj -> g.apply((GetCertificateSigningRequestResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PaymentCryptographyResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCertificateSigningRequestResponse> {
        /**
         * <p>
         * The certificate signing request generated using the key pair associated with the key identifier.
         * </p>
         * 
         * @param certificateSigningRequest
         *        The certificate signing request generated using the key pair associated with the key identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateSigningRequest(String certificateSigningRequest);
    }

    static final class BuilderImpl extends PaymentCryptographyResponse.BuilderImpl implements Builder {
        private String certificateSigningRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCertificateSigningRequestResponse model) {
            super(model);
            certificateSigningRequest(model.certificateSigningRequest);
        }

        public final String getCertificateSigningRequest() {
            return certificateSigningRequest;
        }

        public final void setCertificateSigningRequest(String certificateSigningRequest) {
            this.certificateSigningRequest = certificateSigningRequest;
        }

        @Override
        public final Builder certificateSigningRequest(String certificateSigningRequest) {
            this.certificateSigningRequest = certificateSigningRequest;
            return this;
        }

        @Override
        public GetCertificateSigningRequestResponse build() {
            return new GetCertificateSigningRequestResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
